/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc.agent;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.glassfish.appclient.client.acc.agent.GFDependenciesClassLoader;
import org.glassfish.embeddable.client.ApplicationClientClassLoader;
import org.glassfish.embeddable.client.ApplicationClientContainer;

public class UserClassLoader
extends URLClassLoader
implements ApplicationClientClassLoader {
    private static final Function<Path, URL> PATH_TO_URL = p -> {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not convert path to url: " + String.valueOf(p), e);
        }
    };
    private volatile ApplicationClientContainer container;

    UserClassLoader() {
        super("User", UserClassLoader.createClassPath(), new GFDependenciesClassLoader());
    }

    public ApplicationClientContainer getApplicationClientContainer() {
        return this.container;
    }

    public void setApplicationClientContainer(ApplicationClientContainer container) {
        this.container = container;
    }

    public String toString() {
        StringBuilder text = new StringBuilder(1024);
        text.append(this.getClass().getName()).append('@').append(Integer.toHexString(this.hashCode()));
        text.append("[name=").append(this.getName()).append(']');
        text.append("[container=").append(this.container).append(']');
        text.append(", urls=[\n");
        Arrays.stream(this.getURLs()).forEach(u -> text.append(u).append('\n'));
        text.append(']');
        text.append(", parent=").append(this.getParent());
        return text.toString();
    }

    private static URL[] createClassPath() {
        Stream<Path> hardCodedPaths = UserClassLoader.convertClassPathToPaths(".");
        Stream<Path> cpPaths = UserClassLoader.convertClassPathToPaths(System.getProperty("java.class.path"));
        Stream<Path> envPaths = UserClassLoader.convertClassPathToPaths(System.getenv("APPCPATH"));
        Predicate<Path> filterOutGfClient = f -> !f.endsWith(Path.of("gf-client.jar", new String[0]));
        return (URL[])Stream.of(hardCodedPaths, cpPaths, envPaths).reduce(Stream::concat).orElseGet(Stream::empty).map(Path::toAbsolutePath).map(Path::normalize).distinct().filter(filterOutGfClient).map(PATH_TO_URL).toArray(URL[]::new);
    }

    private static Stream<Path> convertClassPathToPaths(String classPath) {
        if (classPath == null || classPath.isBlank()) {
            return Stream.empty();
        }
        try {
            return Stream.of(classPath.split(File.pathSeparator)).map(File::new).map(File::toPath);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not parse the classpath: " + classPath, e);
        }
    }
}

