/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.enterprise.connectors.authentication.ConnectorSecurityMap;
import com.sun.enterprise.connectors.authentication.EisBackendPrincipal;
import com.sun.enterprise.connectors.authentication.RuntimeSecurityMap;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.glassfish.connectors.config.BackendPrincipal;
import org.glassfish.connectors.config.SecurityMap;

public class SecurityMapUtils {
    public static final String USERMAP = "usermap";
    public static final String GROUPMAP = "groupmap";

    public static RuntimeSecurityMap processSecurityMaps(ConnectorSecurityMap[] securityMaps) {
        if (securityMaps == null || securityMaps.length == 0) {
            return new RuntimeSecurityMap();
        }
        HashMap<String, ResourcePrincipalDescriptor> userMap = new HashMap<String, ResourcePrincipalDescriptor>();
        HashMap<String, ResourcePrincipalDescriptor> groupMap = new HashMap<String, ResourcePrincipalDescriptor>();
        for (ConnectorSecurityMap map : securityMaps) {
            ResourcePrincipalDescriptor principal = SecurityMapUtils.generateResourcePrincipal(map);
            List<String> principalNames = map.getPrincipals();
            for (String principalName : principalNames) {
                userMap.put(principalName, principal);
            }
            List<String> groupNames = map.getUserGroups();
            for (String groupName : groupNames) {
                groupMap.put(groupName, principal);
            }
        }
        return new RuntimeSecurityMap(userMap, groupMap);
    }

    public static ConnectorSecurityMap[] getConnectorSecurityMaps(List<SecurityMap> securityMapList) {
        ConnectorSecurityMap[] maps = null;
        maps = new ConnectorSecurityMap[securityMapList.size()];
        for (int i = 0; i < securityMapList.size(); ++i) {
            maps[i] = SecurityMapUtils.convertSecurityMapConfigBeanToSecurityMap(securityMapList.get(i));
        }
        return maps;
    }

    private static ConnectorSecurityMap convertSecurityMapConfigBeanToSecurityMap(SecurityMap securityMap) {
        String name = securityMap.getName();
        ArrayList<String> principalList = new ArrayList<String>();
        for (Object p : securityMap.getPrincipal()) {
            principalList.add((String)p);
        }
        ArrayList<String> userGroupList = new ArrayList<String>();
        for (String g : securityMap.getUserGroup()) {
            userGroupList.add(g);
        }
        EisBackendPrincipal backendPrincipal = SecurityMapUtils.transformBackendPrincipal(securityMap.getBackendPrincipal());
        return new ConnectorSecurityMap(name, principalList, userGroupList, backendPrincipal);
    }

    private static ResourcePrincipalDescriptor generateResourcePrincipal(ConnectorSecurityMap securityMap) {
        EisBackendPrincipal backendPrincipal = securityMap.getBackendPrincipal();
        String userName = backendPrincipal.getUserName();
        String password = backendPrincipal.getPassword();
        return new ResourcePrincipalDescriptor(userName, password);
    }

    private static EisBackendPrincipal transformBackendPrincipal(BackendPrincipal principal) {
        String userName = principal.getUserName();
        String password = principal.getPassword();
        return new EisBackendPrincipal(userName, password);
    }
}

