/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.logging;

import com.sun.common.util.logging.LoggingConfigImpl;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.LogService;
import com.sun.enterprise.config.serverbeans.ModuleLogLevels;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.embeddable.GlassFishVariable;
import org.glassfish.hk2.api.PostConstruct;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

@Service
public class UpgradeLogging
implements ConfigurationUpgrade,
PostConstruct {
    private static final System.Logger LOG = System.getLogger(UpgradeLogging.class.getName());
    @Inject
    Configs configs;
    @Inject
    LoggingConfigImpl logConfig;

    public void postConstruct() {
        for (Config config : this.configs.getConfig()) {
            this.doUpgrade(config);
        }
    }

    private void doUpgrade(Config config) {
        LogService logService = config.getLogService();
        if (logService == null) {
            return;
        }
        try {
            RepositoryConfig rc = new RepositoryConfig();
            String configDir = rc.getRepositoryRoot() + File.separator + rc.getRepositoryName() + File.separator + rc.getInstanceName() + File.separator + "config";
            PEFileLayout layout = new PEFileLayout(rc);
            File src = new File(layout.getTemplatesDir(), "logging.properties");
            File dest = new File(configDir, "logging.properties");
            if (!dest.exists()) {
                FileUtils.copy((File)src, (File)dest);
            }
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.ERROR, "Failure while upgrading log-service. Could not create logging.properties file.", (Throwable)e);
        }
        try {
            ModuleLogLevels mll = logService.getModuleLogLevels();
            Map logLevels = mll.getAllLogLevels();
            String file = logService.getFile();
            String instanceRoot = System.getProperty(GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName());
            if (file.contains(instanceRoot)) {
                file = file.replace(instanceRoot, "${" + GlassFishVariable.INSTANCE_ROOT.getSystemPropertyName() + "}");
            }
            logLevels.put("file", file);
            logLevels.put("use-system-logging", logService.getUseSystemLogging());
            logLevels.put("log-handler", logService.getLogHandler());
            logLevels.put("log-filter", logService.getLogFilter());
            logLevels.put("log-to-console", logService.getLogToConsole());
            logLevels.put("log-rotation-limit-in-bytes", logService.getLogRotationLimitInBytes());
            logLevels.put("log-rotation-timelimit-in-minutes", logService.getLogRotationTimelimitInMinutes());
            logLevels.put("alarms", logService.getAlarms());
            logLevels.put("retain-error-statistics-for-hours", logService.getRetainErrorStatisticsForHours());
            HashMap m = new HashMap(logLevels);
            ConfigSupport.apply(c -> {
                try {
                    this.logConfig.updateLoggingProperties(m);
                    c.setLogService(null);
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.ERROR, "Failure while upgrading log-service. Could not update logging.properties file.", (Throwable)e);
                }
                return null;
            }, (ConfigBeanProxy)config);
        }
        catch (TransactionFailure e) {
            throw new RuntimeException("Failure while upgrading log-service", e);
        }
    }
}

