/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module.web;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.servlet.ServletContext;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import org.jboss.weld.bean.builtin.AbstractStaticallyDecorableBuiltInBean;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.web.logging.ServletLogger;
import org.jboss.weld.module.web.servlet.ServletContextService;
import org.jboss.weld.security.GetContextClassLoaderAction;

public class ServletContextBean
extends AbstractStaticallyDecorableBuiltInBean<ServletContext> {
    private final ServletContextService servletContexts;

    public ServletContextBean(BeanManagerImpl beanManager) {
        super(beanManager, ServletContext.class);
        this.servletContexts = beanManager.getServices().get(ServletContextService.class);
    }

    @Override
    protected ServletContext newInstance(InjectionPoint ip, CreationalContext<ServletContext> creationalContext) {
        ServletContext ctx = this.servletContexts.getCurrentServletContext();
        if (ctx == null) {
            ClassLoader cl = AccessController.doPrivileged(GetContextClassLoaderAction.INSTANCE);
            throw ServletLogger.LOG.cannotInjectServletContext(cl, this.servletContexts);
        }
        return ctx;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }
}

