/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterConsumerInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolConsumerUIDIterator;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;

public class ClusterMessageInfo {
    protected Logger logger = Globals.getLogger();
    private static final String PROP_PREFIX_CUID_DCT = "CUID-DCT:";
    private static final String PROP_REDELIVERED = "redelivered";
    private PacketReference ref = null;
    private ArrayList<Consumer> consumers = null;
    private ArrayList<Integer> deliveryCnts = null;
    private boolean redelivered = false;
    private boolean sendMessageDeliveredAck = false;
    private Cluster c = null;
    private GPacket pkt = null;
    private DataInputStream dis = null;

    private ClusterMessageInfo(PacketReference ref, ArrayList<Consumer> consumers, ArrayList<Integer> deliveryCnts, boolean redelivered, boolean sendMessageDeliveredAck, Cluster c) {
        this.ref = ref;
        this.consumers = consumers;
        this.deliveryCnts = deliveryCnts;
        this.redelivered = redelivered;
        this.sendMessageDeliveredAck = sendMessageDeliveredAck;
        this.c = c;
    }

    private ClusterMessageInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterMessageInfo newInstance(PacketReference ref, ArrayList<Consumer> consumers, ArrayList<Integer> deliveryCnts, boolean redelivered, boolean sendMessageDeliveredAck, Cluster c) {
        return new ClusterMessageInfo(ref, consumers, deliveryCnts, redelivered, sendMessageDeliveredAck, c);
    }

    public static ClusterMessageInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterMessageInfo(pkt, c);
    }

    public GPacket getGPacket() throws Exception {
        assert (this.ref != null);
        assert (this.consumers != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)1);
        gp.putProp((Object)"D", (Object)this.sendMessageDeliveredAck);
        gp.putProp((Object)"C", (Object)this.consumers.size());
        Globals.getDestinationList();
        if (DestinationList.isPartitionMode()) {
            gp.putProp((Object)"partitionID", (Object)this.ref.getPartitionedStore().getPartitionID().longValue());
        }
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        Packet roPkt = null;
        try {
            for (int i = 0; i < this.consumers.size(); ++i) {
                ConsumerUID intid = this.consumers.get(i).getConsumerUID();
                ClusterConsumerInfo.writeConsumerUID(intid, dos);
                gp.putProp((Object)(PROP_PREFIX_CUID_DCT + intid.longValue()), (Object)this.deliveryCnts.get(i));
            }
            if (this.redelivered) {
                gp.putProp((Object)PROP_REDELIVERED, (Object)this.redelivered);
            }
            if ((roPkt = this.ref.getPacket()) == null) {
                throw new BrokerException(Globals.getBrokerResources().getKString("B4305", this.ref.toString()));
            }
            roPkt.generateTimestamp(false);
            roPkt.generateSequenceNumber(false);
            roPkt.writePacket((OutputStream)dos);
            dos.flush();
            bos.flush();
        }
        catch (Exception e) {
            String emsg = Globals.getBrokerResources().getKString("B4306", this.ref.toString(), e.getMessage());
            if (e instanceof BrokerException) {
                this.logger.log(16, emsg);
                throw e;
            }
            this.logger.logStack(16, emsg, (Throwable)e);
            throw e;
        }
        byte[] buf = bos.toByteArray();
        gp.setPayload(ByteBuffer.wrap(buf));
        return gp;
    }

    public String toString() {
        if (this.consumers == null || this.ref == null) {
            return super.toString();
        }
        StringBuilder buf = new StringBuilder("\n");
        for (int i = 0; i < this.consumers.size(); ++i) {
            ConsumerUID intid = this.consumers.get(i).getConsumerUID();
            buf.append('\t').append(intid).append('\n');
        }
        return buf.toString();
    }

    public Long getPartitionID() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"partitionID");
    }

    public BrokerAddress getHomeBrokerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public boolean getSendMessageDeliveredAck() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp((Object)"D");
    }

    public int getConsumerCount() {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)"C");
    }

    private Boolean getRedelivered() {
        assert (this.pkt != null);
        return (Boolean)this.pkt.getProp((Object)PROP_REDELIVERED);
    }

    public Integer getDeliveryCount(ConsumerUID cuid) {
        assert (this.pkt != null);
        return (Integer)this.pkt.getProp((Object)(PROP_PREFIX_CUID_DCT + cuid.longValue()));
    }

    public void initPayloadRead() {
        assert (this.pkt != null);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.pkt.getPayload().array());
        this.dis = new DataInputStream(bis);
    }

    public Iterator readPayloadConsumerUIDs() {
        assert (this.pkt != null);
        assert (this.dis != null);
        return new ProtocolConsumerUIDIterator(this.dis, this.getConsumerCount());
    }

    public Packet readPayloadMessage() throws IOException {
        assert (this.pkt != null);
        assert (this.dis != null);
        Packet roPkt = new Packet(false);
        roPkt.generateTimestamp(false);
        roPkt.generateSequenceNumber(false);
        roPkt.readPacket((InputStream)this.dis);
        Boolean b = this.getRedelivered();
        if (b != null) {
            roPkt.setRedelivered(b.booleanValue());
        }
        return roPkt;
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int status) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)2);
        gp.putProp((Object)"S", (Object)status);
        return gp;
    }
}

