/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.impl.sql.compile.Token;

class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token token, int[][] nArray, String[] stringArray) {
        super("");
        this.specialConstructor = true;
        this.currentToken = token;
        this.expectedTokenSequences = nArray;
        this.tokenImage = stringArray;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String string) {
        super(string);
        this.specialConstructor = false;
    }

    @Override
    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        Object object = "";
        int n = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (n < this.expectedTokenSequences[i].length) {
                n = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                object = (String)object + this.tokenImage[this.expectedTokenSequences[i][j]] + " ";
            }
            if (this.expectedTokenSequences[i][this.expectedTokenSequences[i].length - 1] != 0) {
                object = (String)object + "...";
            }
            object = (String)object + this.eol + "    ";
        }
        Object object2 = "Encountered \"";
        Token token = this.currentToken.next;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                object2 = (String)object2 + " ";
            }
            if (token.kind == 0) {
                object2 = (String)object2 + this.tokenImage[0];
                break;
            }
            object2 = (String)object2 + this.add_escapes(token.image);
            token = token.next;
        }
        object2 = (String)object2 + "\" at line " + this.currentToken.next.beginLine + ", column " + this.currentToken.next.beginColumn;
        return object2;
    }

    protected String add_escapes(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block11: for (int i = 0; i < string.length(); ++i) {
            switch (string.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block11;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block11;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block11;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block11;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block11;
                }
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    stringBuilder.append("\\'");
                    continue block11;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block11;
                }
                default: {
                    char c = string.charAt(i);
                    if (c < ' ' || c > '~') {
                        String string2 = "0000" + Integer.toString(c, 16);
                        stringBuilder.append("\\u");
                        stringBuilder.append(string2.substring(string2.length() - 4, string2.length()));
                        continue block11;
                    }
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

