/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class BigDecimalConverter
extends NumberConverter<BigDecimal> {
    @Override
    public boolean supports(Class<BigDecimal> rawType, Annotation[] annotations) {
        return BigDecimal.class.equals(rawType);
    }

    @Override
    public ConverterResult<BigDecimal> convert(String value, Class<BigDecimal> rawType, Annotation[] annotations, Locale locale) {
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(val -> val.equals(Double.NaN) ? null : new BigDecimal(val.toString())).orElse(null));
        }
        catch (ParseException e) {
            return ConverterResult.failed(null, e.getMessage());
        }
    }
}

