/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.resourcedef;

import ee.jakarta.tck.concurrent.common.context.IntContext;
import ee.jakarta.tck.concurrent.common.context.StringContext;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.Schedule;
import jakarta.enterprise.context.RequestScoped;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@RequestScoped
public class ReqBean {
    private static final Logger log = Logger.getLogger(ReqBean.class.getCanonicalName());
    private static final long MAX_WAIT_SECONDS = TimeUnit.MINUTES.toSeconds(2L);

    @Asynchronous(executor="java:app/concurrent/ScheduledExecutorA")
    public CompletableFuture<String> awaitAndGetThirdPartyContext(Semaphore invocationsStarted, CountDownLatch blocker) {
        invocationsStarted.release(1);
        CompletableFuture future = Asynchronous.Result.getFuture();
        try {
            blocker.await(MAX_WAIT_SECONDS, TimeUnit.SECONDS);
            future.complete(IntContext.get() + StringContext.get());
        }
        catch (Exception x) {
            future.completeExceptionally(x);
        }
        return future;
    }

    @Asynchronous(executor="java:comp/concurrent/ScheduledExecutorC")
    public CompletionStage<ContextService> lookUpAContextService() {
        try {
            return CompletableFuture.completedFuture((ContextService)InitialContext.doLookup("java:comp/concurrent/ContextC"));
        }
        catch (NamingException x) {
            throw new CompletionException(x);
        }
    }

    public CompletableFuture<String> notAsynchronous() {
        return CompletableFuture.completedFuture(Thread.currentThread().getName());
    }

    @Asynchronous(executor="java:comp/DefaultManagedScheduledExecutorService", runAt={@Schedule(cron="*/5 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery5seconds(int runs, RETURN type, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery5seconds method " + count + "/" + runs + " (Returning: " + type.toString() + ")");
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        switch (type) {
            case NULL: {
                return null;
            }
            case COMPLETE_EXCEPTIONALLY: {
                future.completeExceptionally(new Exception(type.getMessage()));
                break;
            }
            case COMPLETE_RESULT: {
                future.complete(count);
                break;
            }
            case INCOMPLETE: {
                break;
            }
            case THROW_EXCEPTION: {
                throw new RuntimeException(type.getMessage());
            }
        }
        return future;
    }

    @Asynchronous(executor="java:comp/DefaultManagedScheduledExecutorService", runAt={@Schedule(cron="*/3 * * * * *")})
    public void scheduledEvery3SecondsVoidReturn(int runs, RETURN type, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsVoidReturn method " + count + "/" + runs + " (Returning: " + type.toString() + ")");
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        switch (type) {
            case COMPLETE_EXCEPTIONALLY: {
                future.completeExceptionally(new Exception(type.getMessage()));
                break;
            }
            case COMPLETE_RESULT: {
                future.complete(null);
                break;
            }
            case THROW_EXCEPTION: {
                throw new RuntimeException(type.getMessage());
            }
        }
    }

    @Asynchronous(executor="java:comp/DefaultManagedScheduledExecutorService", runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery3SecondsTakes5Seconds(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsTakes5Seconds method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            try {
                Thread.sleep(Duration.ofSeconds(5L).toMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interrupted while waiting", e);
            }
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(count);
        return future;
    }

    @Asynchronous(executor="java:module/concurrent/ScheduledExecutorB", runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<Integer> scheduledEvery3Seconds(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3Seconds method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(IntContext.get());
        return future;
    }

    @Asynchronous(executor="java:module/concurrent/ScheduledExecutorB", runAt={@Schedule(cron="*/3 * * * * *"), @Schedule(cron="0 * * * * *")})
    public CompletableFuture<String> scheduledEvery3SecondsAnd1Minute(int runs, AtomicInteger counter) {
        int count = counter.incrementAndGet();
        log.info("Executing scheduledEvery3SecondsAnd1Minute method " + count + "/" + runs);
        log.info("  Thread: " + Thread.currentThread().toString());
        if (runs != count) {
            return null;
        }
        CompletableFuture future = Asynchronous.Result.getFuture();
        future.complete(StringContext.get());
        return future;
    }

    @Asynchronous(executor="java:app/concurrent/INVALID", runAt={@Schedule(cron="*/3 * * * * *")})
    public CompletableFuture<String> scheduledInvalidExecutor() {
        throw new UnsupportedOperationException("Should not be able to execute with invalid executor");
    }

    public static enum RETURN {
        NULL,
        COMPLETE_EXCEPTIONALLY,
        COMPLETE_RESULT,
        INCOMPLETE,
        THROW_EXCEPTION;

        private String message = "";

        public RETURN withMessage(String m) {
            this.message = m;
            return this;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

