/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi;

import ee.jakarta.tck.concurrent.common.counter.CounterInterface;
import ee.jakarta.tck.concurrent.common.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.tasks.CommonTasks;
import ee.jakarta.tck.concurrent.framework.EJBJNDIProvider;
import ee.jakarta.tck.concurrent.framework.TestConstants;
import ee.jakarta.tck.concurrent.framework.junit.extensions.Wait;
import ee.jakarta.tck.concurrent.spec.ManagedScheduledExecutorService.inheritedapi.TestEjbInterface;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Stateless;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;

@Stateless
public class TestEjb
implements TestEjbInterface {
    @EJB
    private CounterInterface counter;
    @Resource(lookup="java:comp/DefaultManagedScheduledExecutorService")
    private ManagedScheduledExecutorService scheduledExecutor;

    @Override
    public void testApiSubmit() {
        try {
            Future result = this.scheduledExecutor.submit((Callable)new CommonTasks.SimpleCallable());
            Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
            result = this.scheduledExecutor.submit((Runnable)new CommonTasks.SimpleRunnable());
            Wait.waitForTaskComplete(result);
            result = this.scheduledExecutor.submit((Runnable)new CommonTasks.SimpleRunnable(), (Object)"ok");
            Assertions.assertEquals(Wait.waitForTaskComplete(result), (Object)"ok");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testApiExecute() {
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            this.scheduledExecutor.execute((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName()));
            Wait.waitForCounter(() -> this.counter.getCount(), 1);
        }
        finally {
            this.counter.reset();
        }
    }

    @Override
    public void testApiInvokeAll() {
        List resultList;
        ArrayList<Callable<Integer>> taskList;
        try {
            taskList = new ArrayList<Callable<Integer>>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            resultList = this.scheduledExecutor.invokeAll(taskList);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
            resultList = this.scheduledExecutor.invokeAll(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitForTaskComplete(each);
            }
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(0)).get()), (int)1);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(1)).get()), (int)2);
            Assertions.assertEquals((Integer)((Integer)((Future)resultList.get(2)).get()), (int)3);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            resultList = this.scheduledExecutor.invokeAll(taskList, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            for (Future each : resultList) {
                Wait.waitTillFutureThrowsException(each, CancellationException.class);
            }
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
    }

    @Override
    public void testApiInvokeAny() {
        ArrayList<Callable<Integer>> taskList;
        try {
            taskList = new ArrayList<Callable<Integer>>();
            taskList.add(new CommonTasks.SimpleArgCallable(1));
            taskList.add(new CommonTasks.SimpleArgCallable(2));
            taskList.add(new CommonTasks.SimpleArgCallable(3));
            Integer result = (Integer)this.scheduledExecutor.invokeAny(taskList);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
            result = (Integer)this.scheduledExecutor.invokeAny(taskList, TestConstants.waitTimeout.getSeconds(), TimeUnit.SECONDS);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(result, 1, 3);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            taskList = new ArrayList();
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            taskList.add(new CommonTasks.SimpleCallable(TestConstants.waitTimeout));
            this.scheduledExecutor.invokeAny(taskList, TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            return;
        }
        catch (Exception ex) {
            Assertions.fail((String)ex.getMessage());
        }
        Assertions.fail((String)"Task should be cancelled because of timeout");
    }

    @Override
    public void testApiSchedule() {
        try {
            ScheduledFuture result = this.scheduledExecutor.schedule((Callable)new CommonTasks.SimpleCallable(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Assertions.assertEquals((Object)"ok", Wait.waitForTaskComplete(result));
            result = this.scheduledExecutor.schedule((Runnable)new CommonTasks.SimpleRunnable(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Assertions.assertEquals(null, Wait.waitForTaskComplete(result));
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
    }

    @Override
    public void testApiScheduleAtFixedRate() {
        ScheduledFuture result = null;
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            result = this.scheduledExecutor.scheduleAtFixedRate((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName()), TestConstants.pollInterval.getSeconds(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Wait.sleep(TestConstants.waitTimeout);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(this.counter.getCount(), TestConstants.pollsPerTimeout - 2, TestConstants.pollsPerTimeout + 2);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                Wait.waitCancelFuture(result);
            }
            this.counter.reset();
        }
    }

    @Override
    public void testApiScheduleWithFixedDelay() {
        ScheduledFuture result = null;
        try {
            EJBJNDIProvider nameProvider = ServiceLoader.load(EJBJNDIProvider.class).findFirst().orElseThrow();
            result = this.scheduledExecutor.scheduleWithFixedDelay((Runnable)new CounterRunnableTask(nameProvider.getEJBJNDIName(), TestConstants.pollInterval), TestConstants.pollInterval.getSeconds(), TestConstants.pollInterval.getSeconds(), TimeUnit.SECONDS);
            Wait.sleep(TestConstants.waitTimeout);
            ee.jakarta.tck.concurrent.framework.junit.extensions.Assertions.assertBetween(this.counter.getCount(), TestConstants.pollsPerTimeout / 2 - 2, TestConstants.pollsPerTimeout / 2 + 2);
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            if (result != null) {
                Wait.waitCancelFuture(result);
            }
            this.counter.reset();
        }
    }
}

