/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.common.ui;

import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.edapt.common.ui.EcoreUIUtils;
import org.eclipse.emf.edapt.common.ui.PartAdapter;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;

public abstract class MetamodelEditorViewBase
extends ViewPart
implements ISelectionChangedListener {
    private EcoreEditor editor;
    private final IPartListener partListener = new PartAdapter(){

        @Override
        public void partActivated(IWorkbenchPart part) {
            MetamodelEditorViewBase.this.setEditorPart(part);
        }

        @Override
        public void partClosed(IWorkbenchPart part) {
            if (part == MetamodelEditorViewBase.this.editor) {
                MetamodelEditorViewBase.this.setEditor(null);
            }
        }
    };

    public final void createPartControl(Composite parent) {
        this.createActions();
        this.createContents(parent);
        this.setEditorPart((IWorkbenchPart)this.getSite().getPage().getActiveEditor());
        this.getSite().getPage().addPartListener(this.partListener);
    }

    protected void createActions() {
    }

    protected abstract void createContents(Composite var1);

    private void setEditorPart(IWorkbenchPart part) {
        EcoreEditor ecoreEditor;
        if (part instanceof EcoreEditor && EcoreUIUtils.isMetamodelEditor(ecoreEditor = (EcoreEditor)part)) {
            this.setEditor(ecoreEditor);
        }
    }

    private void setEditor(EcoreEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        this.uninstallSelectionChangedListener();
        EcoreEditor oldEditor = this.editor;
        this.editor = newEditor;
        this.editorChanged(oldEditor);
        this.installSelectionChangedListener();
    }

    protected void installSelectionChangedListener() {
        if (this.editor != null) {
            this.editor.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    protected void uninstallSelectionChangedListener() {
        if (this.editor != null) {
            this.editor.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    protected void editorChanged(EcoreEditor oldEditor) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChanged((IStructuredSelection)event.getSelection());
    }

    protected abstract void selectionChanged(IStructuredSelection var1);

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        this.uninstallSelectionChangedListener();
        super.dispose();
    }

    public EcoreEditor getEditor() {
        return this.editor;
    }
}

