/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ide.editor.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecp.ide.editor.view.UnknownFeaturesDialog;
import org.eclipse.emf.ecp.view.internal.provider.Migrator;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class UnknownFeaturesMigrationDialog
extends UnknownFeaturesDialog {
    private final List<Migrator> migrators;
    private final Map<EObject, AnyType> nonMigratedFeatures = new HashMap<EObject, AnyType>();
    private final Shell parentShell;

    public UnknownFeaturesMigrationDialog(Shell parentShell, String title, Map<EObject, AnyType> objects, List<Migrator> migrators) {
        super(parentShell, title, objects);
        this.parentShell = parentShell;
        this.migrators = migrators;
        this.setDescription(migrators.isEmpty() ? "Unkown view model elements or attributes have been found in your view model.\nThey will be dropped on the next save." : "Unkown view model elements or attributes have been found in your view model.\nShould they be migrated? Non-migrated elements will be dropped on the next save.");
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        if (id == 0) {
            label = this.migrators.isEmpty() ? label : "Migrate";
        }
        return super.createButton(parent, id, label, defaultButton);
    }

    private void migrateModels() {
        for (Map.Entry entry : this.objects.entrySet()) {
            EObject key = (EObject)entry.getKey();
            AnyType value = (AnyType)entry.getValue();
            FeatureMap anyAttribute = value.getAnyAttribute();
            FeatureMap mixed = value.getMixed();
            Migrator migrator = this.getMigrator(key);
            if (migrator != null) {
                migrator.migrate(key, anyAttribute, mixed);
                continue;
            }
            this.nonMigratedFeatures.put((EObject)entry.getKey(), (AnyType)entry.getValue());
        }
    }

    private Migrator getMigrator(EObject key) {
        if (this.migrators == null) {
            return null;
        }
        for (Migrator migrator : this.migrators) {
            if (!migrator.isApplicable(key)) continue;
            return migrator;
        }
        return null;
    }

    protected void okPressed() {
        if (!this.migrators.isEmpty()) {
            this.migrateModels();
            if (!this.nonMigratedFeatures.isEmpty()) {
                UnknownFeaturesDialog dialog = new UnknownFeaturesDialog(this.parentShell, "Not migrated features", this.nonMigratedFeatures);
                dialog.open();
            }
        }
        super.okPressed();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}

