/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.swt;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.widgets.Display;

public class RunnableManager {
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicReference<Runnable> pending = new AtomicReference();
    private final Display display;

    public RunnableManager(Display display) {
        this.display = display;
    }

    private void finish(Runnable runnable) {
        this.isRunning.compareAndSet(true, false);
        Runnable next = this.pending.getAndSet(null);
        if (next != null) {
            this.executeAsync(next);
        }
    }

    private Runnable createWrapperRunnable(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    RunnableManager.this.finish(runnable);
                }
            }
        };
    }

    public void executeAsync(Runnable runnable) {
        if (this.isRunning.compareAndSet(false, true)) {
            this.getDisplay().asyncExec(this.createWrapperRunnable(runnable));
        } else {
            this.pending.compareAndSet(null, runnable);
        }
    }

    public synchronized Display getDisplay() {
        return this.display;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }
}

