/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.cdo.internal.core;

import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.workspace.CDOWorkspace;
import org.eclipse.emf.cdo.workspace.CDOWorkspaceConfiguration;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecp.cdo.internal.core.CDOProvider;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.spi.core.InternalProject;

public final class CDOProjectData {
    private final InternalProject project;
    private CDOWorkspace workspace;
    private CDOTransaction transaction;
    private CDOResource rootResource;

    public CDOProjectData(InternalProject project) {
        this.project = project;
    }

    public InternalProject getProject() {
        return this.project;
    }

    public synchronized CDOWorkspace getWorkspace() {
        if (this.workspace == null) {
            CDOWorkspaceConfiguration config = this.createWorkspaceConfiguration();
            this.workspace = config.open();
        }
        return this.workspace;
    }

    public synchronized CDOWorkspace checkoutWorkspace() {
        CDOWorkspaceConfiguration config = this.createWorkspaceConfiguration();
        this.workspace = config.checkout();
        return this.workspace;
    }

    public synchronized CDOTransaction getTransaction() {
        if (this.transaction == null) {
            ResourceSet resourceSet = this.project.getEditingDomain().getResourceSet();
            this.transaction = this.getWorkspace().openTransaction(resourceSet);
        }
        return this.transaction;
    }

    public synchronized CDOResource getRootResource() {
        if (this.rootResource == null) {
            this.rootResource = this.getTransaction().getRootResource();
        }
        return this.rootResource;
    }

    public void dispose() {
        if (this.rootResource != null) {
            this.rootResource = null;
        }
        if (this.transaction != null) {
            this.transaction.close();
            this.transaction = null;
        }
        if (this.workspace != null) {
            this.workspace.close();
            this.workspace = null;
        }
    }

    private CDOWorkspaceConfiguration createWorkspaceConfiguration() {
        CDOProvider provider = (CDOProvider)ECPUtil.getResolvedElement((ECPElement)this.project.getProvider());
        return provider.createWorkspaceConfiguration(this.project);
    }
}

