/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.swt.core.di.extension;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecp.view.model.common.ECPRendererTester;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.internal.swt.core.di.extension.EMFFormsDIWrapperRendererService;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererFactory;
import org.osgi.framework.Bundle;

public class EMFFormsDIExtensionRendererFactory
extends EMFFormsDIRendererFactory {
    private static final String EXTENSION_POINT_ID = "org.eclipse.emfforms.swt.core.di.extension.renderers";

    protected void activate() {
        IConfigurationElement[] configurationElements;
        IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                ECPRendererTester rendererTester = (ECPRendererTester)configurationElement.createExecutableExtension("tester");
                Class<AbstractSWTRenderer<VElement>> rendererClass = this.loadClass(configurationElement.getContributor().getName(), configurationElement.getAttribute("class"));
                EMFFormsDIWrapperRendererService rendererService = new EMFFormsDIWrapperRendererService(rendererClass, rendererTester);
                this.addEMFFormsDIRendererService(rendererService);
            }
            catch (ClassNotFoundException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
            catch (InvalidRegistryObjectException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
            catch (CoreException ex) {
                this.getReportService().report(new AbstractReport((Throwable)ex));
            }
            ++n2;
        }
    }

    private <T> Class<T> loadClass(String bundleName, String clazz) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)bundleName);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(clazz) + bundleName);
        }
        return bundle.loadClass(clazz);
    }
}

