/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.updatesite;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.internal.p2.updatesite.Messages;
import org.eclipse.equinox.internal.p2.updatesite.SiteBundle;
import org.eclipse.equinox.internal.p2.updatesite.SiteCategory;
import org.eclipse.equinox.internal.p2.updatesite.SiteFeature;
import org.eclipse.equinox.internal.p2.updatesite.SiteIU;
import org.eclipse.equinox.internal.p2.updatesite.SiteModel;
import org.eclipse.equinox.internal.p2.updatesite.UpdateSite;
import org.eclipse.equinox.internal.p2.updatesite.VersionSuffixGenerator;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.publisher.AbstractPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.publisher.eclipse.URLEntry;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.eclipse.equinox.spi.p2.publisher.LocalizationHelper;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;

public class SiteXMLAction
extends AbstractPublisherAction {
    private static final String QUALIFIER = "qualifier";
    private static final String P_STATS_URI = "p2.statsURI";
    private static final String P_STATS_MARKER = "download.stats";
    private static final VersionSuffixGenerator versionSuffixGenerator = new VersionSuffixGenerator();
    protected UpdateSite updateSite;
    private SiteCategory defaultCategory;
    private HashSet<SiteCategory> defaultCategorySet;
    protected URI location;
    private String categoryQualifier = null;
    private Version categoryVersion = null;
    private static final IExpression qualifierMatchExpr = ExpressionUtil.parse((String)"id == $0 && version ~= $1");

    public SiteXMLAction(URI location, String categoryQualifier) {
        this.location = location;
        this.categoryQualifier = categoryQualifier;
    }

    public SiteXMLAction(UpdateSite updateSite, String categoryQualifier) {
        this.updateSite = updateSite;
        this.categoryQualifier = categoryQualifier;
    }

    public void setCategoryVersion(String version) {
        this.categoryVersion = Version.parseVersion((String)version);
    }

    private void initialize() {
        if (this.defaultCategory != null) {
            return;
        }
        this.defaultCategory = new SiteCategory();
        this.defaultCategory.setDescription("Default category for otherwise uncategorized features");
        this.defaultCategory.setLabel("Uncategorized");
        this.defaultCategory.setName("Default");
        this.defaultCategorySet = new HashSet(1);
        this.defaultCategorySet.add(this.defaultCategory);
    }

    public IStatus perform(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        if (this.updateSite == null) {
            try {
                this.updateSite = UpdateSite.load(this.location, (Transport)publisherInfo.getMetadataRepository().getProvisioningAgent().getService(Transport.class), monitor);
            }
            catch (ProvisionException e) {
                return new Status(4, Activator.ID, Messages.Error_generating_siteXML, (Throwable)e);
            }
            catch (OperationCanceledException operationCanceledException) {
                return Status.CANCEL_STATUS;
            }
        }
        this.initialize();
        this.initializeRepoFromSite(publisherInfo);
        IStatus markingStats = this.markStatsArtifacts(publisherInfo, results, monitor);
        if (markingStats.isOK()) {
            return this.generateCategories(publisherInfo, results, monitor);
        }
        return markingStats;
    }

    private IStatus markStatsArtifacts(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        boolean markingFeatures;
        SiteBundle[] bundles;
        int n;
        IArtifactRepository artifactRepo = publisherInfo.getArtifactRepository();
        SiteModel site = this.updateSite.getSite();
        SiteFeature[] features = site.getStatsFeatures();
        if (features != null && artifactRepo != null) {
            SiteFeature[] siteFeatureArray = features;
            n = features.length;
            int n2 = 0;
            while (n2 < n) {
                SiteFeature feature = siteFeatureArray[n2];
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Collection<IInstallableUnit> ius = this.getFeatureIU(feature, publisherInfo, results);
                if (ius != null) {
                    for (IInstallableUnit iu : ius) {
                        IArtifactKey key = FeaturesAction.createFeatureArtifactKey((String)feature.getFeatureIdentifier(), (String)iu.getVersion().toString());
                        IArtifactDescriptor[] descriptors = artifactRepo.getArtifactDescriptors(key);
                        if (descriptors.length <= 0 || !(descriptors[0] instanceof ArtifactDescriptor)) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(P_STATS_MARKER, feature.getFeatureIdentifier());
                        ((ArtifactDescriptor)descriptors[0]).addProperties(map);
                    }
                }
                ++n2;
            }
        }
        if ((bundles = site.getStatsBundles()) != null && artifactRepo != null) {
            SiteBundle[] siteBundleArray = bundles;
            int n3 = bundles.length;
            n = 0;
            while (n < n3) {
                SiteBundle bundle = siteBundleArray[n];
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                Collection<IInstallableUnit> ius = this.getBundleIU(bundle, publisherInfo, results);
                if (ius != null) {
                    for (IInstallableUnit iu : ius) {
                        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)iu.getId(), (String)iu.getVersion().toString());
                        IArtifactDescriptor[] descriptors = artifactRepo.getArtifactDescriptors(key);
                        if (descriptors.length <= 0 || !(descriptors[0] instanceof ArtifactDescriptor)) continue;
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put(P_STATS_MARKER, iu.getId());
                        ((ArtifactDescriptor)descriptors[0]).addProperties(map);
                    }
                }
                ++n;
            }
        }
        boolean markingBundles = bundles != null && bundles.length > 0;
        boolean bl = markingFeatures = features != null && features.length > 0;
        if (artifactRepo == null && (markingBundles || markingFeatures)) {
            return new Status(2, Activator.ID, "Artifact repository was not specified so stats properties could not be published.");
        }
        return Status.OK_STATUS;
    }

    private IStatus generateCategories(IPublisherInfo publisherInfo, IPublisherResult results, IProgressMonitor monitor) {
        HashMap<SiteCategory, Set<IInstallableUnit>> categoriesToIUs = new HashMap<SiteCategory, Set<IInstallableUnit>>();
        Map<SiteFeature, Set<SiteCategory>> featuresToCategories = this.getFeatureToCategoryMappings(publisherInfo);
        for (SiteFeature feature : featuresToCategories.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Collection<IInstallableUnit> ius = this.getFeatureIU(feature, publisherInfo, results);
            if (ius == null) continue;
            Set<SiteCategory> categories = featuresToCategories.get(feature);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            for (SiteCategory category : categories) {
                HashSet<IInstallableUnit> iusInCategory = (HashSet<IInstallableUnit>)categoriesToIUs.get(category);
                if (iusInCategory == null) {
                    iusInCategory = new HashSet<IInstallableUnit>();
                    categoriesToIUs.put(category, iusInCategory);
                }
                iusInCategory.addAll(ius);
            }
        }
        Map<SiteBundle, Set<SiteCategory>> bundlesToCategories = this.getBundleToCategoryMappings(publisherInfo);
        for (SiteBundle bundle : bundlesToCategories.keySet()) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Collection<IInstallableUnit> ius = this.getBundleIU(bundle, publisherInfo, results);
            if (ius == null) continue;
            Set<SiteCategory> categories = bundlesToCategories.get(bundle);
            if (categories == null || categories.isEmpty()) {
                categories = this.defaultCategorySet;
            }
            for (SiteCategory category : categories) {
                HashSet<IInstallableUnit> iusInCategory = (HashSet<IInstallableUnit>)categoriesToIUs.get(category);
                if (iusInCategory == null) {
                    iusInCategory = new HashSet<IInstallableUnit>();
                    categoriesToIUs.put(category, iusInCategory);
                }
                iusInCategory.addAll(ius);
            }
        }
        this.addSiteIUsToCategories(categoriesToIUs, publisherInfo, results);
        this.generateCategoryIUs(categoriesToIUs, results);
        return Status.OK_STATUS;
    }

    private void addSiteIUsToCategories(Map<SiteCategory, Set<IInstallableUnit>> categoriesToIUs, IPublisherInfo publisherInfo, IPublisherResult results) {
        SiteIU[] siteIUs;
        Map<SiteIU, Set<SiteCategory>> iusToCategories = this.getIUToCategoryMappings(publisherInfo);
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return;
        }
        SiteIU[] siteIUArray = siteIUs = site.getIUs();
        int n = siteIUs.length;
        int n2 = 0;
        while (n2 < n) {
            SiteIU siteIU = siteIUArray[n2];
            Collection<IInstallableUnit> ius = this.getIUs(siteIU, publisherInfo, results);
            if (ius != null) {
                Set<SiteCategory> categories = iusToCategories.get(siteIU);
                if (categories == null || categories.isEmpty()) {
                    categories = this.defaultCategorySet;
                }
                for (SiteCategory category : categories) {
                    Set<IInstallableUnit> iusInCategory = categoriesToIUs.get(category);
                    if (iusInCategory == null) {
                        iusInCategory = new HashSet<IInstallableUnit>();
                        categoriesToIUs.put(category, iusInCategory);
                    }
                    iusInCategory.addAll(ius);
                }
            }
            ++n2;
        }
    }

    private Map<SiteIU, Set<SiteCategory>> getIUToCategoryMappings(IPublisherInfo publisherInfo) {
        SiteIU[] ius;
        HashMap<SiteIU, Set<SiteCategory>> mappings = new HashMap<SiteIU, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        SiteIU[] siteIUArray = ius = site.getIUs();
        int n = ius.length;
        int n2 = 0;
        while (n2 < n) {
            SiteIU iu = siteIUArray[n2];
            String[] categoryNames = iu.getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(iu, categories);
            String[] stringArray = categoryNames;
            int n3 = categoryNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String categoryName = stringArray[n4];
                SiteCategory category = site.getCategory(categoryName);
                if (category != null) {
                    categories.add(category);
                }
                ++n4;
            }
            ++n2;
        }
        return mappings;
    }

    private Collection<IInstallableUnit> getIUs(SiteIU siteIU, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = siteIU.getID();
        String range = siteIU.getRange();
        String type = siteIU.getQueryType();
        String expression = siteIU.getQueryExpression();
        Object[] params = siteIU.getQueryParams();
        if (id == null && (type == null || expression == null)) {
            return Collections.emptyList();
        }
        IQuery query = null;
        if (id != null) {
            VersionRange vRange = VersionRange.create((String)range);
            query = QueryUtil.createIUQuery((String)id, (VersionRange)vRange);
        } else if (type.equals("context")) {
            query = QueryUtil.createQuery((String)expression, (Object[])params);
        } else if (type.equals("match")) {
            query = QueryUtil.createMatchQuery((String)expression, (Object[])params);
        }
        if (query == null) {
            return Collections.emptyList();
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        return queryResult.toUnmodifiableSet();
    }

    private Collection<IInstallableUnit> getFeatureIU(SiteFeature feature, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = String.valueOf(feature.getFeatureIdentifier()) + ".feature.group";
        String versionString = feature.getFeatureVersion();
        Version version = versionString != null && versionString.length() > 0 ? Version.create((String)versionString) : Version.emptyVersion;
        IQuery query = null;
        if (version.equals(Version.emptyVersion)) {
            query = QueryUtil.createIUQuery((String)id);
        } else {
            String qualifier;
            try {
                qualifier = PublisherHelper.toOSGiVersion((Version)version).getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                qualifier = null;
            }
            if (qualifier != null && qualifier.endsWith(QUALIFIER)) {
                IQuery qualifierQuery;
                VersionRange range = this.createVersionRange(version.toString());
                query = qualifierQuery = QueryUtil.createMatchQuery((IExpression)qualifierMatchExpr, (Object[])new Object[]{id, range});
            } else {
                query = QueryUtil.createLimitQuery((IQuery)QueryUtil.createIUQuery((String)id, (Version)version), (int)1);
            }
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        if (!queryResult.isEmpty()) {
            return queryResult.toUnmodifiableSet();
        }
        return null;
    }

    private Collection<IInstallableUnit> getBundleIU(SiteBundle bundle, IPublisherInfo publisherInfo, IPublisherResult results) {
        String id = bundle.getBundleIdentifier();
        String versionString = bundle.getBundleVersion();
        Version version = versionString != null && versionString.length() > 0 ? Version.create((String)versionString) : Version.emptyVersion;
        IQuery query = null;
        if (version.equals(Version.emptyVersion)) {
            query = QueryUtil.createIUQuery((String)id);
        } else {
            String qualifier;
            try {
                qualifier = PublisherHelper.toOSGiVersion((Version)version).getQualifier();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                qualifier = null;
            }
            if (qualifier != null && qualifier.endsWith(QUALIFIER)) {
                IQuery qualifierQuery;
                VersionRange range = this.createVersionRange(version.toString());
                query = qualifierQuery = QueryUtil.createMatchQuery((IExpression)qualifierMatchExpr, (Object[])new Object[]{id, range});
            } else {
                query = QueryUtil.createLimitQuery((IQuery)QueryUtil.createIUQuery((String)id, (Version)version), (int)1);
            }
        }
        IQueryResult queryResult = results.query(query, null);
        if (queryResult.isEmpty()) {
            queryResult = publisherInfo.getMetadataRepository().query(query, null);
        }
        if (queryResult.isEmpty() && publisherInfo.getContextMetadataRepository() != null) {
            queryResult = publisherInfo.getContextMetadataRepository().query(query, null);
        }
        if (!queryResult.isEmpty()) {
            return queryResult.toUnmodifiableSet();
        }
        return null;
    }

    protected VersionRange createVersionRange(String versionId) {
        VersionRange range = null;
        if (versionId == null || "0.0.0".equals(versionId)) {
            range = VersionRange.emptyRange;
        } else {
            int qualifierIdx = versionId.indexOf(QUALIFIER);
            if (qualifierIdx != -1) {
                String newVersion = versionId.substring(0, qualifierIdx);
                if (newVersion.endsWith(".")) {
                    newVersion = newVersion.substring(0, newVersion.length() - 1);
                }
                Version lower = Version.parseVersion((String)newVersion);
                Version upper = null;
                String newQualifier = VersionSuffixGenerator.incrementQualifier(PublisherHelper.toOSGiVersion((Version)lower).getQualifier());
                org.osgi.framework.Version osgiVersion = PublisherHelper.toOSGiVersion((Version)lower);
                upper = newQualifier == null ? Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)(osgiVersion.getMicro() + 1)) : Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)newQualifier);
                range = new VersionRange(lower, true, upper, false);
            } else {
                range = new VersionRange(Version.parseVersion((String)versionId), true, Version.parseVersion((String)versionId), true);
            }
        }
        return range;
    }

    protected Map<SiteFeature, Set<SiteCategory>> getFeatureToCategoryMappings(IPublisherInfo publisherInfo) {
        SiteFeature[] features;
        HashMap<SiteFeature, Set<SiteCategory>> mappings = new HashMap<SiteFeature, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        SiteFeature[] siteFeatureArray = features = site.getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            SiteFeature feature = siteFeatureArray[n2];
            String[] categoryNames = feature.getCategoryNames();
            Set<SiteCategory> categories = mappings.get(feature);
            if (categories == null) {
                categories = new HashSet<SiteCategory>();
                mappings.put(feature, categories);
            }
            String[] stringArray = categoryNames;
            int n3 = categoryNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String categoryName = stringArray[n4];
                SiteCategory category = site.getCategory(categoryName);
                if (category != null) {
                    categories.add(category);
                }
                ++n4;
            }
            ++n2;
        }
        return mappings;
    }

    protected Map<SiteBundle, Set<SiteCategory>> getBundleToCategoryMappings(IPublisherInfo publisherInfo) {
        SiteBundle[] bundles;
        HashMap<SiteBundle, Set<SiteCategory>> mappings = new HashMap<SiteBundle, Set<SiteCategory>>();
        if (this.updateSite == null) {
            return mappings;
        }
        SiteModel site = this.updateSite.getSite();
        if (site == null) {
            return mappings;
        }
        SiteBundle[] siteBundleArray = bundles = site.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            SiteBundle bundle = siteBundleArray[n2];
            String[] categoryNames = bundle.getCategoryNames();
            HashSet<SiteCategory> categories = new HashSet<SiteCategory>();
            mappings.put(bundle, categories);
            String[] stringArray = categoryNames;
            int n3 = categoryNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String categoryName = stringArray[n4];
                SiteCategory category = site.getCategory(categoryName);
                if (category != null) {
                    categories.add(category);
                }
                ++n4;
            }
            ++n2;
        }
        return mappings;
    }

    private void initializeRepoFromSite(IPublisherInfo publisherInfo) {
        File siteFile;
        String statsURI;
        Object refs;
        URLEntry[] associatedSites;
        SiteModel site = this.updateSite.getSite();
        String mirrors = site.getMirrorsURI();
        if (mirrors != null) {
            int index = mirrors.indexOf("site.xml");
            if (index != -1) {
                mirrors = String.valueOf(mirrors.substring(0, index)) + mirrors.substring(index + "site.xml".length());
            }
            publisherInfo.getMetadataRepository().setProperty("p2.mirrorsURL", mirrors);
            if (publisherInfo.getArtifactRepository() != null) {
                publisherInfo.getArtifactRepository().setProperty("p2.mirrorsURL", mirrors);
            }
        }
        if ((associatedSites = site.getAssociatedSites()) != null) {
            refs = new ArrayList(associatedSites.length * 2);
            URLEntry[] uRLEntryArray = associatedSites;
            int n = associatedSites.length;
            int n2 = 0;
            while (n2 < n) {
                URLEntry associatedSite = uRLEntryArray[n2];
                String siteLocation = associatedSite.getURL();
                try {
                    URI associateLocation = new URI(siteLocation);
                    String label = associatedSite.getAnnotation();
                    ((ArrayList)refs).add(new RepositoryReference(associateLocation, label, 0, 1));
                    ((ArrayList)refs).add(new RepositoryReference(associateLocation, label, 1, 1));
                }
                catch (URISyntaxException uRISyntaxException) {
                    String message = "Invalid site reference: " + siteLocation;
                    LogHelper.log((IStatus)new Status(4, Activator.ID, message));
                }
                ++n2;
            }
            publisherInfo.getMetadataRepository().addReferences((Collection)refs);
        }
        if ((refs = site.getRepositoryReferences()) != null) {
            ArrayList<RepositoryReference> toAdd = new ArrayList<RepositoryReference>(Arrays.asList(refs));
            publisherInfo.getMetadataRepository().addReferences(toAdd);
        }
        if ((statsURI = site.getStatsURI()) != null && statsURI.length() > 0 && publisherInfo.getArtifactRepository() != null) {
            publisherInfo.getArtifactRepository().setProperty(P_STATS_URI, statsURI);
        }
        if ((siteFile = URIUtil.toFile((URI)this.updateSite.getLocation())) != null && siteFile.exists()) {
            String[] keyStrings;
            File siteParent = siteFile.getParentFile();
            List<String> messageKeys = site.getMessageKeys();
            if (siteParent.isDirectory()) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getDirPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            } else if (siteFile.getName().endsWith(".jar")) {
                keyStrings = messageKeys.toArray(new String[messageKeys.size()]);
                site.setLocalizations(LocalizationHelper.getJarPropertyLocalizations((File)siteParent, (String)"site", null, (String[])keyStrings));
            }
        }
    }

    protected void generateCategoryIUs(Map<SiteCategory, Set<IInstallableUnit>> categoriesToIUs, IPublisherResult result) {
        HashMap<String, SiteCategory> nameToCategory = new HashMap<String, SiteCategory>();
        SiteCategory[] siteCategoryArray = this.updateSite.getSite().getCategories();
        int n = siteCategoryArray.length;
        int n2 = 0;
        while (n2 < n) {
            SiteCategory category = siteCategoryArray[n2];
            nameToCategory.put(category.getName(), category);
            ++n2;
        }
        final HashMap categoryToNestedCategories = new HashMap();
        SiteCategory[] siteCategoryArray2 = this.updateSite.getSite().getCategories();
        int n3 = siteCategoryArray2.length;
        n = 0;
        while (n < n3) {
            SiteCategory category = siteCategoryArray2[n];
            String[] stringArray = category.getCategoryNames();
            int n4 = stringArray.length;
            int n5 = 0;
            while (n5 < n4) {
                String parentCategoryName = stringArray[n5];
                SiteCategory parentCategory = (SiteCategory)nameToCategory.get(parentCategoryName);
                if (categoryToNestedCategories.get(parentCategory) == null) {
                    categoryToNestedCategories.put(parentCategory, new HashSet());
                }
                ((Set)categoryToNestedCategories.get(parentCategory)).add(category);
                ++n5;
            }
            ++n;
        }
        ArrayList<SiteCategory> categories = new ArrayList<SiteCategory>(Arrays.asList(this.updateSite.getSite().getCategories()));
        categories.add(this.defaultCategory);
        Comparator<SiteCategory> isNestedCategoryComparator = new Comparator<SiteCategory>(){

            @Override
            public int compare(SiteCategory category1, SiteCategory category2) {
                int res;
                Set childrenOfCategory1 = (Set)categoryToNestedCategories.get(category1);
                Set childrenOfCategory2 = (Set)categoryToNestedCategories.get(category2);
                if (childrenOfCategory1 != null && childrenOfCategory1.contains(category2)) {
                    return 1;
                }
                if (childrenOfCategory2 != null && childrenOfCategory2.contains(category1)) {
                    return -1;
                }
                if (childrenOfCategory1 != null) {
                    for (SiteCategory childOfCategory1 : childrenOfCategory1) {
                        res = this.compare(childOfCategory1, category2);
                        if (res == 0) continue;
                        return res;
                    }
                }
                if (childrenOfCategory2 != null) {
                    for (SiteCategory childOfCategory2 : childrenOfCategory2) {
                        res = this.compare(category1, childOfCategory2);
                        if (res == 0) continue;
                        return res;
                    }
                }
                return 0;
            }
        };
        categories.sort(isNestedCategoryComparator);
        HashMap<String, IInstallableUnit> nameToCategoryIU = new HashMap<String, IInstallableUnit>();
        for (SiteCategory category : categories) {
            Set nestedCategories;
            Set<IInstallableUnit> units = categoriesToIUs.get(category);
            if (units == null) {
                units = new HashSet<IInstallableUnit>();
            }
            if ((nestedCategories = (Set)categoryToNestedCategories.get(category)) != null) {
                for (SiteCategory nestedCategory : nestedCategories) {
                    IInstallableUnit nestedCategoryIU = (IInstallableUnit)nameToCategoryIU.get(nestedCategory.getName());
                    if (nestedCategoryIU == null) continue;
                    units.add(nestedCategoryIU);
                }
            }
            if (units.isEmpty()) continue;
            IInstallableUnit categoryIU = this.createCategoryIU(category, units);
            result.addIU(categoryIU, "non_root");
            nameToCategoryIU.put(category.getName(), categoryIU);
        }
    }

    @Deprecated
    public IInstallableUnit createCategoryIU(SiteCategory category, Set<IInstallableUnit> childrenIUs, IInstallableUnit nestedCategory) {
        HashSet<IInstallableUnit> allIUs = new HashSet<IInstallableUnit>();
        if (childrenIUs != null) {
            allIUs.addAll(childrenIUs);
        }
        if (nestedCategory != null) {
            allIUs.add(nestedCategory);
        }
        return this.createCategoryIU(category, allIUs);
    }

    public IInstallableUnit createCategoryIU(SiteCategory category, Set<IInstallableUnit> childrenIUs) {
        MetadataFactory.InstallableUnitDescription cat = new MetadataFactory.InstallableUnitDescription();
        cat.setSingleton(true);
        String categoryId = this.buildCategoryId(category.getName());
        cat.setId(categoryId);
        if (this.categoryVersion == null) {
            cat.setVersion(Version.createOSGi((int)1, (int)0, (int)0, (String)versionSuffixGenerator.generateSuffix(childrenIUs, Collections.emptyList())));
        } else {
            org.osgi.framework.Version osgiVersion;
            String qualifier;
            if (this.categoryVersion.isOSGiCompatible() && (qualifier = (osgiVersion = PublisherHelper.toOSGiVersion((Version)this.categoryVersion)).getQualifier()).endsWith(QUALIFIER)) {
                String suffix = versionSuffixGenerator.generateSuffix(childrenIUs, Collections.emptyList());
                qualifier = String.valueOf(qualifier.substring(0, qualifier.length() - 9)) + suffix;
                this.categoryVersion = Version.createOSGi((int)osgiVersion.getMajor(), (int)osgiVersion.getMinor(), (int)osgiVersion.getMicro(), (String)qualifier);
            }
            cat.setVersion(this.categoryVersion);
        }
        String label = category.getLabel();
        cat.setProperty("org.eclipse.equinox.p2.name", label != null ? label : category.getName());
        cat.setProperty("org.eclipse.equinox.p2.description", category.getDescription());
        ArrayList<IRequirement> reqsConfigurationUnits = new ArrayList<IRequirement>(childrenIUs.size());
        for (IInstallableUnit iu : childrenIUs) {
            VersionRange range = new VersionRange(iu.getVersion(), true, iu.getVersion(), true);
            reqsConfigurationUnits.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)iu.getId(), (VersionRange)range, (IMatchExpression)iu.getFilter(), (boolean)false, (boolean)false));
        }
        cat.setRequirements(reqsConfigurationUnits.toArray(new IRequirement[reqsConfigurationUnits.size()]));
        ArrayList<IProvidedCapability> providedCapabilities = new ArrayList<IProvidedCapability>();
        providedCapabilities.add(PublisherHelper.createSelfCapability((String)categoryId, (Version)cat.getVersion()));
        Map<Locale, Map<String, String>> localizations = category.getLocalizations();
        if (localizations != null) {
            for (Map.Entry<Locale, Map<String, String>> locEntry : localizations.entrySet()) {
                Locale locale = locEntry.getKey();
                Map<String, String> translatedStrings = locEntry.getValue();
                for (Map.Entry<String, String> e : translatedStrings.entrySet()) {
                    cat.setProperty(String.valueOf(locale.toString()) + '.' + e.getKey(), e.getValue());
                }
                providedCapabilities.add(PublisherHelper.makeTranslationCapability((String)categoryId, (Locale)locale));
            }
        }
        cat.setCapabilities(providedCapabilities.toArray(new IProvidedCapability[providedCapabilities.size()]));
        cat.setArtifacts(new IArtifactKey[0]);
        cat.setProperty("org.eclipse.equinox.p2.type.category", "true");
        return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)cat);
    }

    private String buildCategoryId(String categoryName) {
        if (this.categoryQualifier != null) {
            if (this.categoryQualifier.length() > 0) {
                return String.valueOf(this.categoryQualifier) + "." + categoryName;
            }
            return categoryName;
        }
        if (this.updateSite != null) {
            return String.valueOf(URIUtil.toUnencodedString((URI)this.updateSite.getLocation())) + "." + categoryName;
        }
        return categoryName;
    }

    protected Transport getTransport(IPublisherInfo info) {
        IMetadataRepository repo = info.getMetadataRepository();
        if (repo == null) {
            repo = info.getArtifactRepository();
        }
        if (repo == null) {
            throw new IllegalStateException("The transport service can not be found.");
        }
        return (Transport)repo.getProvisioningAgent().getService(Transport.class);
    }
}

