/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.merge.specification;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.DefaultMatchPolicy;
import org.eclipse.emf.diffmerge.util.ModelImplUtil;
import org.eclipse.emf.diffmerge.util.structures.comparable.ComparableLinkedList;
import org.eclipse.emf.diffmerge.util.structures.comparable.IComparableStructure;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class MultiCriteriaMatchPolicy
extends DefaultMatchPolicy {
    private final Set<MatchCriterionKind> _selectedCriteria = new HashSet<MatchCriterionKind>(MatchCriterionKind.values().length);

    public MultiCriteriaMatchPolicy() {
        this._selectedCriteria.addAll(this.getDefaultCriteria());
    }

    public Collection<MatchCriterionKind> getApplicableCriteria() {
        return Arrays.asList(MatchCriterionKind.STRUCTURE, MatchCriterionKind.NAME, MatchCriterionKind.INTRINSIC_ID, MatchCriterionKind.EXTRINSIC_ID);
    }

    protected ComparableLinkedList<String> getContainerRelativeID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p, MatchCriterionKind criterion_p) {
        String lastIDPart = criterion_p == MatchCriterionKind.STRUCTURE ? this.getStructureMatchIDPart(element_p, scope_p, inScopeOnly_p) : this.getUniqueName(element_p, scope_p, inScopeOnly_p);
        ComparableLinkedList<String> result = this.getContainerRelativeID(element_p, scope_p, inScopeOnly_p, lastIDPart);
        return result;
    }

    protected ComparableLinkedList<String> getContainerRelativeID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p, String idSuffix_p) {
        ComparableLinkedList result = null;
        if (idSuffix_p != null) {
            EObject container = this.getContainer(element_p, scope_p, inScopeOnly_p);
            if (container != null) {
                IComparableStructure<?> containerID = this.getMatchID(container, scope_p);
                if (containerID instanceof ComparableLinkedList) {
                    result = (ComparableLinkedList)containerID;
                    result.add((Object)idSuffix_p);
                } else if (containerID instanceof String) {
                    result = new ComparableLinkedList();
                    result.add((Object)((String)containerID));
                    result.add((Object)idSuffix_p);
                }
            } else {
                result = new ComparableLinkedList();
                result.add((Object)idSuffix_p);
            }
        }
        return result;
    }

    protected EObject getContainer(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        Object result = inScopeOnly_p ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainer(element_p) : null) : element_p.eContainer();
        return result;
    }

    protected EReference getContainment(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        Object result = inScopeOnly_p ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainment(element_p) : null) : element_p.eContainmentFeature();
        return result;
    }

    public Collection<MatchCriterionKind> getDefaultCriteria() {
        return Arrays.asList(MatchCriterionKind.INTRINSIC_ID);
    }

    protected <T extends Comparable<T>> ComparableLinkedList<T> getEncapsulateOrNull(T object_p) {
        ComparableLinkedList result = null;
        if (object_p != null) {
            result = new ComparableLinkedList();
            result.add(object_p);
        }
        return result;
    }

    protected String getExtrinsicID(EObject element_p, IModelScope scope_p) {
        return ModelImplUtil.getXMLID((EObject)element_p);
    }

    public IComparableStructure<?> getMatchID(EObject element_p, IModelScope scope_p) {
        IComparableStructure<?> result = null;
        Iterator<MatchCriterionKind> it = this.getApplicableCriteria().iterator();
        while (result == null && it.hasNext()) {
            MatchCriterionKind criterion = it.next();
            if (!this.useMatchCriterion(criterion)) continue;
            result = this.getMatchID(element_p, scope_p, criterion);
        }
        return result;
    }

    public IComparableStructure<?> getMatchID(EObject element_p, IModelScope scope_p, MatchCriterionKind criterion_p) {
        ComparableLinkedList<String> result;
        switch (criterion_p) {
            case EXTRINSIC_ID: {
                result = this.getEncapsulateOrNull(this.getExtrinsicID(element_p, scope_p));
                break;
            }
            case INTRINSIC_ID: {
                result = this.getEncapsulateOrNull(this.getIntrinsicID(element_p));
                break;
            }
            case STRUCTURE: 
            case NAME: {
                result = this.getContainerRelativeID(element_p, scope_p, this.isScopeOnly(), criterion_p);
                break;
            }
            default: {
                result = this.getSemanticID(element_p, scope_p, this.isScopeOnly());
            }
        }
        return result;
    }

    protected String getUniqueName(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        String result = null;
        if (element_p instanceof ENamedElement) {
            result = ((ENamedElement)element_p).getName();
        }
        return result;
    }

    protected IComparableStructure<?> getSemanticID(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        return null;
    }

    protected String getStructureMatchIDPart(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        String result = null;
        EReference containment = this.getContainment(element_p, scope_p, inScopeOnly_p);
        if (containment != null && this.isDiscriminatingContainment(element_p, containment)) {
            result = this.getStructureReferenceIDPart(element_p, containment);
        } else if (this.isUniqueRootOfItsType(element_p, scope_p, inScopeOnly_p)) {
            result = this.getStructureRootIDPart(element_p);
        }
        return result;
    }

    protected String getStructureReferenceIDPart(EObject element_p, EReference containment_p) {
        String result = "::" + containment_p.getName();
        return result;
    }

    protected String getStructureRootIDPart(EObject element_p) {
        String result = "root::" + element_p.eClass().getName();
        return result;
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return !containment_p.isMany();
    }

    protected boolean isScopeOnly() {
        return true;
    }

    protected boolean isUniqueOfItsTypeAmong(EObject element_p, Collection<? extends EObject> collection_p) {
        Iterator<? extends EObject> it = collection_p.iterator();
        EClass type = element_p.eClass();
        boolean isPresent = false;
        boolean sameType = false;
        while (it.hasNext() && !sameType) {
            EObject root = it.next();
            if (root == element_p) {
                isPresent = true;
                continue;
            }
            if (root.eClass() != type) continue;
            sameType = true;
        }
        boolean result = isPresent && !sameType;
        return result;
    }

    protected boolean isUniqueRootOfItsType(EObject element_p, IModelScope scope_p, boolean inScopeOnly_p) {
        boolean result = false;
        EObject container = this.getContainer(element_p, scope_p, inScopeOnly_p);
        if (container == null) {
            Resource resource = element_p.eResource();
            List collection = inScopeOnly_p || resource == null ? scope_p.getContents() : resource.getContents();
            result = this.isUniqueOfItsTypeAmong(element_p, collection);
        }
        return result;
    }

    public void setUseMatchCriterion(MatchCriterionKind criterion_p, boolean use_p) {
        if (use_p) {
            this._selectedCriteria.add(criterion_p);
        } else {
            this._selectedCriteria.remove((Object)criterion_p);
        }
    }

    public boolean useMatchCriterion(MatchCriterionKind criterion_p) {
        return this._selectedCriteria.contains((Object)criterion_p);
    }

    public static enum MatchCriterionKind {
        SEMANTICS,
        STRUCTURE,
        NAME,
        INTRINSIC_ID,
        EXTRINSIC_ID;

    }
}

