/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.activity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ObjectNodeKind implements Enumerator
{
    UNSPECIFIED(0, "Unspecified", "Unspecified"),
    NO_BUFFER(1, "NoBuffer", "NoBuffer"),
    OVERWRITE(2, "Overwrite", "Overwrite");

    public static final int UNSPECIFIED_VALUE = 0;
    public static final int NO_BUFFER_VALUE = 1;
    public static final int OVERWRITE_VALUE = 2;
    private static final ObjectNodeKind[] VALUES_ARRAY;
    public static final List<ObjectNodeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ObjectNodeKind[]{UNSPECIFIED, NO_BUFFER, OVERWRITE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ObjectNodeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ObjectNodeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ObjectNodeKind get(int value) {
        switch (value) {
            case 0: {
                return UNSPECIFIED;
            }
            case 1: {
                return NO_BUFFER;
            }
            case 2: {
                return OVERWRITE;
            }
        }
        return null;
    }

    private ObjectNodeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

