/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.polarsys.capella.xmlpivot.extraction.BasicConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.ConceptualMapping;
import org.polarsys.capella.xmlpivot.extraction.ExportActionLauncher;
import org.polarsys.capella.xmlpivot.extraction.MemoizingConceptualMapping;

public class DynamicConceptualMapping
extends BasicConceptualMapping {
    private static final URI DYNAMIC_BASE_URI = URI.createPlatformResourceURI((String)"/Simplified Capella Metamodel", (boolean)true);
    private static final String ECORE_EXTENSION = "ecore";
    private final ResourceSet resourceSet = new ResourceSetImpl();

    protected DynamicConceptualMapping(EPackage.Registry registry_p) {
        super(registry_p);
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(ECORE_EXTENSION, new EcoreResourceFactoryImpl());
    }

    @Override
    protected EPackage delegateGetSimplifiedPackage(EPackage pack) {
        return this.transformAndRegister(pack);
    }

    private Collection<EPackage> transformAndRegister(Collection<EPackage> packages_p) {
        BasicConceptualMapping context = new BasicConceptualMapping(this.registry);
        ExportActionLauncher launcher = new ExportActionLauncher();
        ExportActionLauncher.Result result = launcher.launch(packages_p, context, null);
        for (EPackage target : result.getTargetPackages()) {
            if (target.getESuperPackage() == null) {
                Resource targetResource = this.resourceSet.createResource(DYNAMIC_BASE_URI.appendSegment(String.valueOf(target.getName()) + "." + ECORE_EXTENSION));
                targetResource.getContents().add((Object)target);
            }
            this.registry.put((Object)target.getNsURI(), (Object)target);
        }
        return result.getTargetPackages();
    }

    private EPackage transformAndRegister(EPackage pack_p) {
        Collection<EPackage> result = this.transformAndRegister(Collections.singleton(pack_p));
        for (EPackage p : result) {
            if (!p.getNsURI().equals(this.metadata.getSimplifiedNsURI(pack_p))) continue;
            return p;
        }
        throw new IllegalStateException();
    }

    public static ConceptualMapping create(EPackage.Registry registry, Collection<EPackage> sourcePackages) {
        DynamicConceptualMapping cm = new DynamicConceptualMapping(registry);
        cm.transformAndRegister(sourcePackages);
        return new MemoizingConceptualMapping(cm);
    }
}

