/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.modifiers;

import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.editors.modifiers.EditingDomainCellModifier;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.TableItem;

public class VariablesTableCellModifier
extends EditingDomainCellModifier {
    public VariablesTableCellModifier(TransactionalEditingDomain editingDomain, TableViewer tableViewer) {
        super(editingDomain, tableViewer);
    }

    public boolean canModify(Object element, String property) {
        if ("Name".equals(property)) {
            return true;
        }
        return "Type".equals(property);
    }

    public Object getValue(Object element, String property) {
        if (element instanceof PatternVariable) {
            PatternVariable patternVariable = (PatternVariable)element;
            if ("Name".equals(property)) {
                return patternVariable.getName();
            }
            if ("Type".equals(property)) {
                String type = patternVariable.getType();
                return ParametersTableLabelProvider.getType(type);
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        if (element instanceof TableItem) {
            element = ((TableItem)element).getData();
        }
        String text = value.toString().trim();
        if (element instanceof PatternVariable) {
            PatternVariable patternVariable = (PatternVariable)element;
            if ("Name".equals(property)) {
                this.executeModify(patternVariable, text);
            }
        }
    }

    private void executeModify(final PatternVariable patternVariable, final String text) {
        Runnable cmd = new Runnable(){

            @Override
            public void run() {
                patternVariable.setName(text);
            }
        };
        this.doModify(cmd);
    }
}

