/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.fcore.commands.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class FcoreDragAndDropCommand
extends DragAndDropCommand {
    public FcoreDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        this(domain, owner, location, operations, operation, collection, domain == null ? false : domain.getOptimizeCopy());
    }

    public FcoreDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection, boolean optimize) {
        super(domain, owner, location, operations, operation, collection);
    }

    protected boolean prepareDropCopyInsert(Object parent, Collection<?> children, int index) {
        boolean result;
        if (this.collection == null || this.collection.isEmpty()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            result = false;
        } else if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            result = false;
        } else {
            this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection);
            if (this.optimize) {
                result = this.optimizedCanExecute();
                if (result) {
                    this.optimizedDropCommandOwner = parent;
                }
            } else if (this.dragCommand.canExecute() && this.dragCommand.canUndo()) {
                this.dragCommand.execute();
                this.isDragCommandExecuted = true;
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)parent, null, (Collection)this.dragCommand.getResult(), (int)index);
                if (this.analyzeForNonContainment(this.dropCommand)) {
                    this.dropCommand.dispose();
                    this.dropCommand = UnexecutableCommand.INSTANCE;
                    this.dragCommand.undo();
                    this.dragCommand.dispose();
                    this.isDragCommandExecuted = false;
                    this.dragCommand = IdentityCommand.INSTANCE;
                }
                result = this.dropCommand.canExecute();
            } else {
                this.dropCommand = UnexecutableCommand.INSTANCE;
                result = false;
            }
        }
        return result;
    }

    protected boolean prepareDropCopyOn() {
        boolean result;
        if (this.collection == null || this.collection.isEmpty()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
            return false;
        }
        this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection);
        if (this.optimize) {
            result = this.optimizedCanExecute();
            if (result) {
                this.optimizedDropCommandOwner = this.owner;
            }
        } else {
            if (this.dragCommand.canExecute() && this.dragCommand.canUndo()) {
                this.dragCommand.execute();
                this.isDragCommandExecuted = true;
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)this.dragCommand.getResult());
                if (this.analyzeForNonContainment(this.dropCommand)) {
                    this.dropCommand.dispose();
                    this.dropCommand = UnexecutableCommand.INSTANCE;
                    this.dragCommand.undo();
                    this.dragCommand.dispose();
                    this.isDragCommandExecuted = false;
                    this.dragCommand = IdentityCommand.INSTANCE;
                }
            } else {
                this.dropCommand = UnexecutableCommand.INSTANCE;
            }
            result = this.dragCommand.canExecute() && this.dropCommand.canExecute();
        }
        return result;
    }

    protected boolean prepareDropMoveInsert(Object parent, Collection<?> children, int index) {
        if (this.collection == null || this.collection.isEmpty()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (this.collection.contains(this.owner)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (children.containsAll(this.collection)) {
            this.dragCommand = IdentityCommand.INSTANCE;
            CompoundCommand compoundCommand = new CompoundCommand();
            ArrayList before = new ArrayList();
            ArrayList after = new ArrayList();
            int j = 0;
            for (Object object : children) {
                if (this.collection.contains(object)) {
                    if (j < index) {
                        before.add(object);
                    } else if (j > index) {
                        after.add(object);
                    }
                }
                ++j;
            }
            for (Object object : before) {
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parent, null, object, (int)(index - 1)));
            }
            ListIterator objects = after.listIterator(after.size());
            while (objects.hasPrevious()) {
                Object object = objects.previous();
                compoundCommand.append(MoveCommand.create((EditingDomain)this.domain, (Object)parent, null, object, (int)index));
            }
            this.dropCommand = compoundCommand.getCommandList().size() == 0 ? IdentityCommand.INSTANCE : compoundCommand;
        } else if (this.isCrossDomain()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            Resource resource = null;
            resource = parent instanceof Resource ? (Resource)parent : ((EObject)parent).eResource();
            EObject firstEObject = (EObject)this.collection.iterator().next();
            this.dropCommand = firstEObject.eResource() == resource ? AddCommand.create((EditingDomain)this.domain, (Object)parent, null, (Collection)this.collection, (int)index) : AddCommand.create((EditingDomain)this.domain, (Object)parent, null, (Collection)CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection).getResult(), (int)index);
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = firstEObject.eResource() == resource ? RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection) : IdentityCommand.INSTANCE;
            }
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }

    protected boolean prepareDropMoveOn() {
        if (this.collection == null || this.collection.isEmpty()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else if (this.isCrossDomain()) {
            this.dragCommand = IdentityCommand.INSTANCE;
            this.dropCommand = UnexecutableCommand.INSTANCE;
        } else {
            Resource resource = null;
            resource = this.owner instanceof Resource ? (Resource)this.owner : ((EObject)this.owner).eResource();
            EObject firstEObject = (EObject)this.collection.iterator().next();
            this.dropCommand = firstEObject.eResource() == resource ? AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)this.collection) : AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)CopyCommand.create((EditingDomain)this.domain, (Collection)this.collection).getResult());
            if (this.analyzeForNonContainment(this.dropCommand)) {
                this.dropCommand.dispose();
                this.dropCommand = UnexecutableCommand.INSTANCE;
                this.dragCommand = IdentityCommand.INSTANCE;
            } else {
                this.dragCommand = firstEObject.eResource() == resource ? RemoveCommand.create((EditingDomain)this.domain, (Collection)this.collection) : IdentityCommand.INSTANCE;
            }
        }
        return this.dragCommand.canExecute() && this.dropCommand.canExecute();
    }
}

