/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.functionalChain;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.common.statemachine.validation.StateMachineUtils;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.validation.functionalChain.FunctionalChainAnalysisResult;
import org.polarsys.capella.vp.ms.CSConfiguration;

public final class FunctionalAnalysisUtils {
    private FunctionalAnalysisUtils() {
    }

    public static EList<Component> getInvolvedComponents(FunctionalChain functionalChain) {
        BasicEList involvedComponents = new BasicEList();
        for (AbstractFunction abstractFunction : functionalChain.getInvolvedFunctions()) {
            if (abstractFunction.getAllocationBlocks().isEmpty() || !(abstractFunction.getAllocationBlocks().get(0) instanceof Component) || involvedComponents.contains(abstractFunction.getAllocationBlocks().get(0))) continue;
            involvedComponents.add((Object)((Component)abstractFunction.getAllocationBlocks().get(0)));
        }
        return involvedComponents;
    }

    public static EList<FunctionalChain> getFunctionalChainInvolvers(Component component) {
        BasicEList fcInvolvers = new BasicEList();
        for (AbstractFunction abstractFunction : component.getAllocatedFunctions()) {
            for (FunctionalChain fc : abstractFunction.getInvolvingFunctionalChains()) {
                if (fcInvolvers.contains((Object)fc)) continue;
                fcInvolvers.add((Object)fc);
            }
        }
        return fcInvolvers;
    }

    public static EList<State> getAllStates(Component component) {
        BasicEList allStates = new BasicEList();
        for (StateMachine stateMachine : component.getOwnedStateMachines()) {
            allStates.addAll(StateMachineUtils.getAllStates(stateMachine));
        }
        return allStates;
    }

    public static EList<AbstractFunction> getCommonFunctions(Component component, FunctionalChain functionalChain) {
        BasicEList commonFunctions = new BasicEList((Collection)component.getAllocatedFunctions());
        BasicEList allocatedFunctionsToComponent = new BasicEList((Collection)component.getAllocatedFunctions());
        allocatedFunctionsToComponent.removeAll((Collection)functionalChain.getInvolvedFunctions());
        commonFunctions.removeAll((Collection)allocatedFunctionsToComponent);
        return commonFunctions;
    }

    public static List<FunctionalChainAnalysisResult> analyzeFC_State(FunctionalChain fc, State state, Component component, EList<AbstractFunction> commonFunctions) {
        ArrayList<FunctionalChainAnalysisResult> fcAnalysisResults = new ArrayList<FunctionalChainAnalysisResult>();
        if (!StateMachineUtils.getConfigurations((AbstractState)state).isEmpty()) {
            for (CSConfiguration configuration : StateMachineUtils.getConfigurations((AbstractState)state)) {
                BasicEList missingFunctions = new BasicEList(commonFunctions);
                missingFunctions.removeAll((Collection)configuration.getFunctions());
                if (configuration.getFunctions().containsAll(commonFunctions)) continue;
                FunctionalChainAnalysisResult fcAnalysisResult = new FunctionalChainAnalysisResult(fc, state, component, configuration, (EList<AbstractFunction>)missingFunctions);
                fcAnalysisResults.add(fcAnalysisResult);
            }
        } else if (!Collections2.filter((Collection)component.getOwnedExtensions(), (Predicate)Predicates.instanceOf(CSConfiguration.class)).isEmpty()) {
            FunctionalChainAnalysisResult fcAnalysisResult = new FunctionalChainAnalysisResult(fc, state, component, null, null);
            fcAnalysisResults.add(fcAnalysisResult);
        }
        return fcAnalysisResults;
    }
}

