/*
 * Decompiled with CFR 0.152.
 */
package ms.design;

import ms.configuration.services.cs.CsConfigurationServices;
import ms.configuration.services.cs.Images;
import ms.design.CSConfigurationStyle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.FlatContainerStyle;
import org.eclipse.sirius.diagram.Square;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtensionProvider;
import org.eclipse.sirius.viewpoint.BasicLabelStyle;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.sirius.viewpoint.Style;

public class CSSRefreshExtension
implements IRefreshExtensionProvider,
IRefreshExtension {
    private static RGBValues conflictColor = RGBValues.create((int)255, (int)165, (int)0);
    private static RGBValues excludeColor = RGBValues.create((int)220, (int)220, (int)220);
    private static RGBValues excludeForegroundColor = RGBValues.create((int)200, (int)200, (int)200);
    private static RGBValues excludeBackroundColor = RGBValues.create((int)200, (int)200, (int)200);
    private static RGBValues excludeLabelColor = RGBValues.create((int)120, (int)120, (int)120);

    public boolean provides(DDiagram diagram) {
        return CsConfigurationServices.isConfigurationsLayerActive(diagram);
    }

    public IRefreshExtension getRefreshExtension(DDiagram viewPoint) {
        return this;
    }

    public void beforeRefresh(DDiagram dDiagram) {
    }

    public void postRefresh(DDiagram dDiagram) {
        for (DDiagramElement e : dDiagram.getDiagramElements()) {
            this.applyStyles(e);
        }
    }

    public void applyStyles(DDiagramElement element) {
        CSConfigurationStyle style = (CSConfigurationStyle)EcoreUtil.getExistingAdapter((Notifier)element, CSConfigurationStyle.class);
        if (style != null) {
            if (CsConfigurationServices.isConsistentIncludeRequired()) {
                if (style.hasClass("excluded")) {
                    if (CsConfigurationServices.isMarkConflictingInclusions() && style.hasClass("included")) {
                        this.applyConflict(element);
                    } else {
                        this.applyExclude(element);
                    }
                }
            } else if (!style.hasClass("included") && style.hasClass("excluded")) {
                this.applyExclude(element);
            }
        }
    }

    private void applyConflict(DDiagramElement element) {
        Style style = element.getStyle();
        if (style instanceof Square) {
            ((Square)style).setColor(conflictColor);
        } else if (style instanceof EdgeStyle) {
            ((EdgeStyle)style).setStrokeColor(conflictColor);
        } else {
            this.applyExclude(element);
        }
    }

    private void applyExclude(DDiagramElement element) {
        Style style = element.getStyle();
        if (style instanceof BasicLabelStyle) {
            ((BasicLabelStyle)style).setLabelColor(excludeLabelColor);
        }
        if (style instanceof FlatContainerStyle) {
            ((FlatContainerStyle)style).setBackgroundColor(excludeBackroundColor);
            ((FlatContainerStyle)style).setForegroundColor(excludeForegroundColor);
        } else if (style instanceof Square) {
            ((Square)style).setColor(excludeColor);
        } else if (style instanceof EdgeStyle) {
            ((EdgeStyle)style).setStrokeColor(excludeColor);
            if (((EdgeStyle)style).getCenterLabelStyle() != null) {
                ((EdgeStyle)style).getCenterLabelStyle().setLabelColor(excludeLabelColor);
            }
        } else if (style instanceof WorkspaceImage) {
            ((WorkspaceImage)style).setWorkspacePath(Images.getImagePath(element.getTarget(), element));
        }
    }

    public CSConfigurationStyle getCSConfigurationStyle(EObject view) {
        CSConfigurationStyle style = (CSConfigurationStyle)EcoreUtil.getExistingAdapter((Notifier)view, CSConfigurationStyle.class);
        if (style == null) {
            style = new CSConfigurationStyle();
            view.eAdapters().add((Object)style);
        }
        return style;
    }
}

