/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.ms.expression.parser;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.vp.ms.AndOperation;
import org.polarsys.capella.vp.ms.BooleanExpression;
import org.polarsys.capella.vp.ms.BooleanOperation;
import org.polarsys.capella.vp.ms.InSituationExpression;
import org.polarsys.capella.vp.ms.InStateExpression;
import org.polarsys.capella.vp.ms.MsFactory;
import org.polarsys.capella.vp.ms.MsPackage;
import org.polarsys.capella.vp.ms.util.MsSwitch;

public class LinkedText2Situation {

    public static class SplitExpression
    extends LinkedHashMap<StateMachine, BooleanExpression> {
        private AndOperation expression;

        private SplitExpression(BooleanExpression expression) throws IllegalArgumentException {
            if (expression != null && expression.eClass() != MsPackage.Literals.AND_OPERATION) {
                throw new IllegalArgumentException("Argument must be an AND operation");
            }
            this.expression = (AndOperation)expression;
        }

        public static SplitExpression of(BooleanExpression expression) throws IllegalArgumentException {
            SplitExpression split = new SplitExpression(expression);
            split.split();
            return split;
        }

        public AndOperation merge() {
            if (this.isEmpty()) {
                return null;
            }
            if (this.expression == null) {
                this.expression = MsFactory.eINSTANCE.createAndOperation();
            } else {
                this.expression.getChildren().clear();
            }
            this.expression.getChildren().addAll(this.values());
            return this.expression;
        }

        private void split() throws IllegalArgumentException {
            StateMachineCounter counter = new StateMachineCounter();
            if (this.expression != null) {
                block4: for (BooleanExpression child : this.expression.getChildren()) {
                    Set childReferencedStateMachines = (Set)counter.doSwitch((EObject)child);
                    switch (childReferencedStateMachines.size()) {
                        case 0: {
                            throw new IllegalArgumentException("Found no statemachine references in subexpression");
                        }
                        case 1: {
                            StateMachine sm = (StateMachine)childReferencedStateMachines.iterator().next();
                            if (this.put(sm, child) == null) continue block4;
                            throw new IllegalArgumentException("Found references to " + sm.getName() + " in more than one subexpressions");
                        }
                        default: {
                            throw new IllegalArgumentException("Found reference to more than one statemachine in a subexpression");
                        }
                    }
                }
            }
        }

        private class StateMachineCounter
        extends MsSwitch<Set<StateMachine>> {
            private StateMachineCounter() {
            }

            public Set<StateMachine> caseBooleanOperation(BooleanOperation object) {
                HashSet<StateMachine> result = new HashSet<StateMachine>();
                for (BooleanExpression child : object.getChildren()) {
                    Set childMachines = (Set)this.doSwitch((EObject)child);
                    result.addAll(childMachines);
                }
                return result;
            }

            public Set<StateMachine> caseInStateExpression(InStateExpression object) {
                StateMachine sm = (StateMachine)EcoreUtil2.getFirstContainer((EObject)object.getState(), (EClass)CapellacommonPackage.Literals.STATE_MACHINE);
                return Collections.singleton(sm);
            }

            public Set<StateMachine> caseInSituationExpression(InSituationExpression object) {
                return (Set)this.doSwitch((EObject)object.getSituation().getExpression());
            }
        }
    }

    public static enum Token {
        AND("AND"),
        OR("OR"),
        NOT("NOT"),
        PAREN_O("("),
        PAREN_C(")"),
        HYPERLINK(null),
        EOS(null),
        ERROR(null);

        String literal;

        private Token(String literal) {
            this.literal = literal;
        }

        public String getLiteral() {
            return this.literal;
        }
    }
}

