/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.common.statemachine.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.sirius.analysis.SequenceDiagramServices;

public final class InteractionUtils {
    private InteractionUtils() {
    }

    public static EObject getFirstElementInExecution(List<EObject> orderedElementsOfInstanceRole) {
        if (!orderedElementsOfInstanceRole.isEmpty() && orderedElementsOfInstanceRole.get(0) instanceof StateFragment) {
            StateFragment stateFragment = (StateFragment)orderedElementsOfInstanceRole.get(0);
            if (stateFragment.getRelatedAbstractFunction() != null) {
                return stateFragment.getRelatedAbstractFunction();
            }
            if (stateFragment.getRelatedAbstractState() != null) {
                return stateFragment.getRelatedAbstractState();
            }
        }
        return null;
    }

    public static List<EObject> getAllElementsInExecution(List<EObject> orderedElementsOfInstanceRole) {
        BasicEList elementsInExecution = new BasicEList();
        for (EObject elementOfInstanceRole : orderedElementsOfInstanceRole) {
            if (elementOfInstanceRole instanceof StateFragment) {
                StateFragment stateFragment = (StateFragment)elementOfInstanceRole;
                if (stateFragment.getRelatedAbstractFunction() != null) {
                    elementsInExecution.add(stateFragment.getRelatedAbstractFunction());
                    continue;
                }
                if (stateFragment.getRelatedAbstractState() != null) {
                    elementsInExecution.add(stateFragment.getRelatedAbstractState());
                    continue;
                }
                elementsInExecution.add(null);
                continue;
            }
            if (!(elementOfInstanceRole instanceof Execution)) continue;
            elementsInExecution.add(elementOfInstanceRole);
        }
        return elementsInExecution;
    }

    public static List<EObject> getOrderedElementsOfInstanceRole(InstanceRole ir) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        Scenario scenario = (Scenario)ir.eContainer();
        Stack<Object> execStack = new Stack<Object>();
        for (InteractionFragment ifgt : InteractionUtils.getOrderedInteractionFragments(scenario)) {
            TimeLapse endingExec;
            TimeLapse startingExec;
            if (ifgt instanceof AbstractEnd) {
                AbstractEnd ae = (AbstractEnd)ifgt;
                if (ae.getCovered() != ir) continue;
                for (TimeLapse laptime : scenario.getOwnedTimeLapses()) {
                    Execution exec2;
                    if (!(laptime instanceof Execution) || (exec2 = (Execution)laptime).getCovered() != ir) continue;
                    if (exec2.getStart() == ae && execStack.isEmpty()) {
                        result.add((EObject)exec2);
                        execStack.push(exec2);
                    }
                    if (exec2.getFinish() != ae) continue;
                    execStack.pop();
                }
                continue;
            }
            if (!ifgt.getCoveredInstanceRoles().contains((Object)ir)) continue;
            if (ifgt instanceof InteractionState && execStack.isEmpty()) {
                result.add((EObject)InteractionUtils.getStartingExecution(ifgt));
            }
            if ((startingExec = InteractionUtils.getStartingExecution(ifgt)) != null && startingExec instanceof Execution) {
                execStack.push(startingExec);
            }
            if ((endingExec = InteractionUtils.getEndingExecution(ifgt)) == null || !(endingExec instanceof Execution)) continue;
            execStack.pop();
        }
        return result;
    }

    public static List<InteractionFragment> getOrderedInteractionFragments(Scenario scenario) {
        if (scenario == null) {
            return new ArrayList<InteractionFragment>();
        }
        return scenario.getOwnedInteractionFragments();
    }

    public static TimeLapse getStartingExecution(InteractionFragment ifg) {
        Scenario s = SequenceDiagramServices.getScenario((EObject)ifg);
        for (TimeLapse lap : s.getOwnedTimeLapses()) {
            if (lap.getStart() != ifg) continue;
            return lap;
        }
        return null;
    }

    public static TimeLapse getEndingExecution(InteractionFragment ifg) {
        Scenario s = SequenceDiagramServices.getScenario((EObject)ifg);
        for (TimeLapse lap : s.getOwnedTimeLapses()) {
            if (lap.getFinish() != ifg) continue;
            return lap;
        }
        return null;
    }

    public static boolean isLifeLineInInteraction(FunctionalExchange functionalExchange, InstanceRole instanceRole) {
        Scenario scenario = SequenceDiagramServices.getScenario((EObject)instanceRole);
        if (functionalExchange.getSourceFunctionOutputPort().eContainer() instanceof AbstractFunction) {
            AbstractFunction functionSource = (AbstractFunction)functionalExchange.getSourceFunctionOutputPort().eContainer();
            for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
                if (instanceRole.equals(role) || !functionSource.getAllocationBlocks().contains((Object)role.getRepresentedInstance().getAbstractType())) continue;
                return true;
            }
        }
        return false;
    }
}

