/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.transition.system2subsystem.tests.crossphases;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.transition.system2subsystem.tests.AbstractSystem2SubsystemTest;
import org.polarsys.capella.transition.system2subsystem.tests.crossphases.CrossPhasesTest;

public class PhysicalToSystemComponent {
    public static final String PC1 = "581d4e58-c3fb-40ac-8c27-b0b31bf63431";
    public static final String PC11 = "461435b7-5c4c-4080-92d6-89d8401252ab";
    public static final String PC2 = "a5c9fb66-c6ec-4213-b93c-c52d6f9da50f";
    public static final String A = "d88b8928-bb26-4047-b071-b5a4aa6edace";
    public static final String B = "8bc10921-c766-42ea-9455-ccb597a4ca88";
    public static final String PARENT = "5a2e2eb1-9780-4d6d-a25a-0f58bad29a11";
    public static final String PART_A = "7d8ab67a-99d2-4646-aab9-842ae69e1d96";
    public static final String PART_B = "8a2199a5-9b2c-4dd4-a95d-a586496c3e81";
    public static final String PART_PARENT = "730d1e95-531f-4966-9f82-d208c7951c14";

    public static class Test1
    extends CrossPhasesTest {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{PhysicalToSystemComponent.PC11});
        }

        @Override
        protected void verify() {
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC11);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.PC11), AbstractSystem2SubsystemTest.ComponentType.SYSTEM);
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC2);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.PC2), AbstractSystem2SubsystemTest.ComponentType.ACTOR);
        }
    }

    public static class Test2
    extends CrossPhasesTest {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{PhysicalToSystemComponent.PC11});
        }

        @Override
        protected void verify() {
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC11);
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC2);
            this.testAttributeIdentity(this.retrieveReferenceElement(PhysicalToSystemComponent.PC11), this.retrieveTargetElement(PhysicalToSystemComponent.PC11), ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME);
        }
    }

    public static class Test3
    extends CrossPhasesTest {
        @Override
        public List<String> getRequiredTestModels() {
            return Arrays.asList("Project_test_01", "fragmentedOutput");
        }

        @Override
        protected String getOutputModelPlatformURIString() {
            return "/fragmentedOutput/fragmentedOutput.capella";
        }

        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{PhysicalToSystemComponent.PC11});
        }

        @Override
        protected void verify() {
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC11);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.PC11), AbstractSystem2SubsystemTest.ComponentType.SYSTEM);
            this.retrieveReferenceElement(PhysicalToSystemComponent.PC2);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.PC2), AbstractSystem2SubsystemTest.ComponentType.ACTOR);
        }
    }

    public static class Test4
    extends CrossPhasesTest {
        @Override
        protected Collection<?> getProjectionElements() {
            return this.getObjects(new String[]{PhysicalToSystemComponent.B});
        }

        @Override
        protected void verify() {
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.A), AbstractSystem2SubsystemTest.ComponentType.ACTOR);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.B), AbstractSystem2SubsystemTest.ComponentType.SYSTEM);
            this.testInstanceOf(this.retrieveTargetElement(PhysicalToSystemComponent.PARENT), AbstractSystem2SubsystemTest.ComponentType.ACTOR);
            SystemAnalysis targetSystemAnalysis = this.retrieveTargetSystemAnalysis();
            SystemComponentPkg pkg = targetSystemAnalysis.getOwnedSystemComponentPkg();
            Test4.assertTrue((boolean)pkg.getOwnedParts().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.PART_PARENT)));
            Test4.assertTrue((boolean)pkg.getOwnedParts().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.PART_A)));
            Test4.assertTrue((boolean)pkg.getOwnedParts().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.PART_B)));
            Test4.assertTrue((boolean)pkg.getOwnedSystemComponents().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.A)));
            Test4.assertTrue((boolean)pkg.getOwnedSystemComponents().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.B)));
            Test4.assertTrue((boolean)pkg.getOwnedSystemComponents().contains((Object)this.retrieveTargetElement(PhysicalToSystemComponent.PARENT)));
        }
    }
}

