/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.tests.ju.tests.misc;

import java.util.Arrays;
import org.polarsys.capella.filtering.AssociatedFilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.FilteringCriterionSet;
import org.polarsys.capella.filtering.FilteringFactory;
import org.polarsys.capella.filtering.model.helpers.FilteringCriterionSetHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class FilteringCriterionSetHelperTest
extends BasicTestCase {
    FilteringCriterion criteria1;
    FilteringCriterion criteria2;
    FilteringCriterion criteria3;
    FilteringCriterion criteria4;
    FilteringCriterion criteria5;

    public void test() throws Exception {
        this.testUnionOf();
        this.testIntersectionOfOverlapingLists();
        this.testIntersectionOfDistinctLists();
        this.testIntersectionOf3OverlapingLists();
        this.testIntersectionOf2OverlapingAnd1Distinct();
    }

    public void setUp() throws Exception {
        super.setUp();
        this.criteria1 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria1.setName("criteria1");
        this.criteria2 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria2.setName("criteria2");
        this.criteria3 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria3.setName("criteria3");
        this.criteria4 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria4.setName("criteria4");
        this.criteria5 = FilteringFactory.eINSTANCE.createFilteringCriterion();
        this.criteria5.setName("criteria5");
    }

    private void testUnionOf() {
        AssociatedFilteringCriterionSet filteringCriterionSetA = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria1);
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria2);
        AssociatedFilteringCriterionSet filteringCriterionSetB = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria3);
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria4);
        FilteringCriterionSet unionSet = FilteringCriterionSetHelper.unionOf((FilteringCriterionSet[])new FilteringCriterionSet[]{filteringCriterionSetA, filteringCriterionSetB});
        AssociatedFilteringCriterionSet expectedSet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        expectedSet.getFilteringCriteria().addAll(Arrays.asList(this.criteria1, this.criteria2, this.criteria3, this.criteria4));
        FilteringCriterionSetHelperTest.assertEquals((Object)expectedSet.getFilteringCriteria(), (Object)unionSet.getFilteringCriteria());
    }

    private void testIntersectionOfOverlapingLists() {
        AssociatedFilteringCriterionSet filteringCriterionSetA = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria1);
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria2);
        AssociatedFilteringCriterionSet filteringCriterionSetB = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria2);
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria3);
        FilteringCriterionSet intersectionSet = FilteringCriterionSetHelper.intersectionOf((FilteringCriterionSet[])new FilteringCriterionSet[]{filteringCriterionSetA, filteringCriterionSetB});
        AssociatedFilteringCriterionSet expectedSet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        expectedSet.getFilteringCriteria().addAll(Arrays.asList(this.criteria2));
        FilteringCriterionSetHelperTest.assertEquals((Object)expectedSet.getFilteringCriteria(), (Object)intersectionSet.getFilteringCriteria());
    }

    private void testIntersectionOfDistinctLists() {
        AssociatedFilteringCriterionSet filteringCriterionSetA = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria1);
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria2);
        AssociatedFilteringCriterionSet filteringCriterionSetB = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria3);
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria4);
        FilteringCriterionSet intersectionSet = FilteringCriterionSetHelper.intersectionOf((FilteringCriterionSet[])new FilteringCriterionSet[]{filteringCriterionSetA, filteringCriterionSetB});
        AssociatedFilteringCriterionSet emptySet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        FilteringCriterionSetHelperTest.assertEquals((Object)emptySet.getFilteringCriteria(), (Object)intersectionSet.getFilteringCriteria());
    }

    private void testIntersectionOf3OverlapingLists() {
        AssociatedFilteringCriterionSet filteringCriterionSetA = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria1);
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria2);
        AssociatedFilteringCriterionSet filteringCriterionSetB = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria2);
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria3);
        AssociatedFilteringCriterionSet filteringCriterionSetC = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetC.getFilteringCriteria().add((Object)this.criteria2);
        filteringCriterionSetC.getFilteringCriteria().add((Object)this.criteria5);
        FilteringCriterionSet intersectionSet = FilteringCriterionSetHelper.intersectionOf((FilteringCriterionSet[])new FilteringCriterionSet[]{filteringCriterionSetA, filteringCriterionSetB, filteringCriterionSetC});
        AssociatedFilteringCriterionSet expectedSet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        expectedSet.getFilteringCriteria().addAll(Arrays.asList(this.criteria2));
        FilteringCriterionSetHelperTest.assertEquals((Object)expectedSet.getFilteringCriteria(), (Object)intersectionSet.getFilteringCriteria());
    }

    private void testIntersectionOf2OverlapingAnd1Distinct() {
        AssociatedFilteringCriterionSet filteringCriterionSetA = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria1);
        filteringCriterionSetA.getFilteringCriteria().add((Object)this.criteria2);
        AssociatedFilteringCriterionSet filteringCriterionSetB = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria2);
        filteringCriterionSetB.getFilteringCriteria().add((Object)this.criteria3);
        AssociatedFilteringCriterionSet filteringCriterionSetC = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        filteringCriterionSetC.getFilteringCriteria().add((Object)this.criteria4);
        filteringCriterionSetC.getFilteringCriteria().add((Object)this.criteria5);
        FilteringCriterionSet intersectionSet = FilteringCriterionSetHelper.intersectionOf((FilteringCriterionSet[])new FilteringCriterionSet[]{filteringCriterionSetA, filteringCriterionSetB, filteringCriterionSetC});
        AssociatedFilteringCriterionSet emptySet = FilteringFactory.eINSTANCE.createAssociatedFilteringCriterionSet();
        FilteringCriterionSetHelperTest.assertEquals((Object)emptySet.getFilteringCriteria(), (Object)intersectionSet.getFilteringCriteria());
    }
}

