/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.filtering.validation.constraints;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.filtering.FilteringCriterion;
import org.polarsys.capella.filtering.tools.utils.FilteringUtils;
import org.polarsys.capella.filtering.validation.constraints.ConstraintsUtil;

public class MDCHK_D_FunctionalExchange_Functions
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)eObj;
            ActivityNode functionOutputPort = fe.getSource();
            ActivityNode functionInputPort = fe.getTarget();
            EObject outputFunctionObject = functionOutputPort.eContainer();
            EObject inputFunctionObject = functionInputPort.eContainer();
            List feFeatures = FilteringUtils.getAssociatedCriteria((EObject)fe);
            List outputFunctionFeatures = FilteringUtils.getAssociatedCriteria((EObject)outputFunctionObject);
            List<FilteringCriterion> missingOutputFeatures = ConstraintsUtil.missingFilteringCriteria(feFeatures, outputFunctionFeatures);
            List inputFunctionFeatures = FilteringUtils.getAssociatedCriteria((EObject)inputFunctionObject);
            List<FilteringCriterion> missingInputFeatures = ConstraintsUtil.missingFilteringCriteria(feFeatures, inputFunctionFeatures);
            String message = "";
            if (!missingOutputFeatures.isEmpty()) {
                message = String.valueOf(ConstraintsUtil.getNameForMessage(outputFunctionObject)) + " is missing " + "[" + FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingOutputFeatures) + "]";
            }
            if (!missingInputFeatures.isEmpty()) {
                if (!message.isEmpty()) {
                    message = String.valueOf(message) + " and ";
                }
                message = String.valueOf(message) + ConstraintsUtil.getNameForMessage(inputFunctionObject) + " is missing " + "[" + FilteringUtils.getCommaSeparatedFilteringCriteriaList(missingInputFeatures) + "]";
            }
            if (!message.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{ConstraintsUtil.getNameForMessage((EObject)fe), FilteringUtils.getCommaSeparatedFilteringCriteriaList((List)feFeatures), message});
            }
        }
        return ctx.createSuccessStatus();
    }
}

