/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.odesign;

import java.util.ArrayList;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.componentization.ViewpointRegistry;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.test.diagram.common.ju.wrapper.utils.ODesignHelper;
import org.polarsys.capella.test.framework.api.BasicTestCase;

public class CyberElementsHaveDirectEditLabelTest
extends BasicTestCase {
    StringBuilder failedTest = new StringBuilder();

    public void test() throws Exception {
        ArrayList<DiagramElementMapping> diagramElementMappings = new ArrayList<DiagramElementMapping>();
        Viewpoint viewpoint = ViewpointRegistry.getInstance().getViewpoint(URI.createURI((String)"viewpoint:/org.polarsys.capella.cybersecurity.sirius.analysis/Cybersecurity"));
        diagramElementMappings.addAll(StreamSupport.stream(Spliterators.spliteratorUnknownSize(viewpoint.eResource().getAllContents(), 0), false).filter(DiagramElementMapping.class::isInstance).map(x -> (DiagramElementMapping)x).filter(ODesignHelper::isNotDeprecatedMapping).collect(Collectors.toList()));
        this.checkMappingsHasEditLabels(diagramElementMappings);
        if (this.failedTest.length() == 0) {
            CyberElementsHaveDirectEditLabelTest.assertTrue((boolean)true);
        } else {
            System.err.println(this.failedTest.toString());
            CyberElementsHaveDirectEditLabelTest.assertTrue((String)this.failedTest.toString(), (boolean)false);
        }
    }

    protected void checkMappingsHasEditLabels(List<DiagramElementMapping> mappingsToCheck) {
        if (mappingsToCheck != null) {
            for (DiagramElementMapping mapping : mappingsToCheck) {
                EdgeMapping edgeMapping;
                if (mapping instanceof AbstractNodeMapping) {
                    AbstractNodeMapping nodeMapping = (AbstractNodeMapping)mapping;
                    if (nodeMapping.getDomainClass() == null || nodeMapping.getLabelDirectEdit() != null) continue;
                    this.failedTest.append("No DirectEditLabel for: " + ODesignHelper.computeModelPath((RepresentationElementMapping)mapping) + "\n");
                    continue;
                }
                if (!(mapping instanceof EdgeMapping) || !(edgeMapping = (EdgeMapping)mapping).isUseDomainElement() || edgeMapping.getLabelDirectEdit() != null) continue;
                this.failedTest.append("No DirectEditLabel for: " + ODesignHelper.computeModelPath((RepresentationElementMapping)mapping) + "\n");
            }
        }
    }
}

