/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.diagram;

import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.cybersecurity.model.PrimaryAsset;
import org.polarsys.capella.cybersecurity.model.Threat;
import org.polarsys.capella.cybersecurity.test.diagram.CyberDiagramLayers;
import org.polarsys.capella.test.diagram.common.ju.context.DiagramContext;
import org.polarsys.capella.test.diagram.common.ju.context.OABDiagram;
import org.polarsys.capella.test.diagram.common.ju.step.crud.CreateDiagramStep;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreateContainerTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.CreatePathTool;
import org.polarsys.capella.test.diagram.common.ju.step.tools.InsertRemoveTool;
import org.polarsys.capella.test.framework.context.SessionContext;

public class CyberOABDiagram
extends OABDiagram {
    public CyberOABDiagram(SessionContext context, DDiagram diagram) {
        super(context, diagram);
    }

    public static CyberOABDiagram createDiagram(SessionContext context, String targetIdentifier) {
        CyberOABDiagram diagram = (CyberOABDiagram)((DiagramContext)new CreateDiagramStep(context, targetIdentifier, "Operational Entity Blank"){

            public DiagramContext getResult() {
                return new CyberOABDiagram(this.getExecutionContext(), this.diagram);
            }
        }.run()).open();
        CyberDiagramLayers.activateLayer(context.getSession(), diagram.getDiagram(), "Cybersecurity Assets Layer");
        return diagram;
    }

    public void insertPrimaryAsset(PrimaryAsset pa) {
        InsertRemoveTool irt = new InsertRemoveTool((DiagramContext)this, "Primary Assets");
        irt.insert(new String[]{pa.getId()});
        irt.getResult();
    }

    public void removePrimaryAsset(PrimaryAsset pa) {
        new InsertRemoveTool((DiagramContext)this, "Primary Assets").remove(new String[]{pa.getId()});
    }

    public void insertThreat(Threat threat) {
        new InsertRemoveTool((DiagramContext)this, "Threats").insert(new String[]{threat.getId()});
    }

    public void removeThreat(Threat threat) {
        new InsertRemoveTool((DiagramContext)this, "Threats").remove(new String[]{threat.getId()});
    }

    public void createFunctionalChain(String path, String ... links) {
        new CreatePathTool((DiagramContext)this, "operational.process", path, links).run();
    }

    public String createEntity(String id, String containerId) {
        DDiagramElementContainer element = (DDiagramElementContainer)new CreateContainerTool((DiagramContext)this, "operational.entity", containerId, id).run();
        return ((CapellaElement)element.getTarget()).getId();
    }
}

