/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.sirius.analysis.internal;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.tools.internal.command.UndoRedoCapableEMFCommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.polarsys.capella.cybersecurity.sirius.analysis.internal.ShowHideNodeCommandBuilder;
import org.polarsys.capella.cybersecurity.sirius.analysis.internal.ShowHideNodeContainerCommandBuilder;

public class CybersecurityDiagramCommandFactory
extends UndoRedoCapableEMFCommandFactory {
    public static final String SHOW_HIDE_MARKER_ID = "show_hide__.";
    private final IDiagramCommandFactoryProvider delegate;

    public CybersecurityDiagramCommandFactory(TransactionalEditingDomain domain, IDiagramCommandFactoryProvider delegate) {
        super(domain);
        this.delegate = delegate;
    }

    private boolean isShowHideTool(AbstractToolDescription tool) {
        return tool.getName().startsWith(SHOW_HIDE_MARKER_ID);
    }

    public Command buildCreateNodeCommandFromTool(DDiagram diagram, NodeCreationDescription tool) {
        if (this.isShowHideTool((AbstractToolDescription)tool)) {
            ShowHideNodeCommandBuilder builder = new ShowHideNodeCommandBuilder(tool, diagram);
            builder.init(this.modelAccessor, this.domain, this.uiCallBack);
            return builder.buildCommand();
        }
        return this.delegate.getCommandFactory(this.domain).buildCreateNodeCommandFromTool(diagram, tool);
    }

    public Command buildCreateNodeCommandFromTool(DDiagramElementContainer container, NodeCreationDescription tool) {
        if (this.isShowHideTool((AbstractToolDescription)tool)) {
            ShowHideNodeCommandBuilder builder = new ShowHideNodeCommandBuilder(tool, (DDiagramElement)container);
            builder.init(this.modelAccessor, this.domain, this.uiCallBack);
            return builder.buildCommand();
        }
        return this.delegate.getCommandFactory(this.domain).buildCreateNodeCommandFromTool(container, tool);
    }

    public Command buildCreateContainerCommandFromTool(DDiagram diagram, ContainerCreationDescription tool) {
        if (this.isShowHideTool((AbstractToolDescription)tool)) {
            ShowHideNodeContainerCommandBuilder builder = new ShowHideNodeContainerCommandBuilder(tool, diagram);
            builder.init(this.modelAccessor, this.domain, this.uiCallBack);
            return builder.buildCommand();
        }
        return this.delegate.getCommandFactory(this.domain).buildCreateContainerCommandFromTool(diagram, tool);
    }

    public Command buildCreateContainerCommandFromTool(DDiagramElementContainer nodeContainer, ContainerCreationDescription tool) {
        if (this.isShowHideTool((AbstractToolDescription)tool)) {
            ShowHideNodeContainerCommandBuilder builder = new ShowHideNodeContainerCommandBuilder(tool, nodeContainer);
            builder.init(this.modelAccessor, this.domain, this.uiCallBack);
            return builder.buildCommand();
        }
        return this.delegate.getCommandFactory(this.domain).buildCreateContainerCommandFromTool(nodeContainer, tool);
    }

    public UICallBack getUserInterfaceCallBack() {
        if (this.uiCallBack == null) {
            return new EMFCommandFactoryUI();
        }
        return this.uiCallBack;
    }
}

