/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.stsmigration.internal;

import org.eclipse.buildship.stsmigration.internal.StsMigrationDialog;
import org.eclipse.buildship.stsmigration.internal.StsMigrationState;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

final class StsMigrationService {
    private final StsMigrationState migrationState;
    private final StsMigrationDialog.Factory dialogFactory;

    StsMigrationService(StsMigrationState migrationState, StsMigrationDialog.Factory dialogFactory) {
        this.migrationState = migrationState;
        this.dialogFactory = dialogFactory;
    }

    void run() {
        if (this.shouldDisplayNotification()) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    StsMigrationDialog dialog = StsMigrationService.this.dialogFactory.newInstance(shell, StsMigrationService.this.migrationState);
                    dialog.open();
                }
            });
        }
    }

    private boolean shouldDisplayNotification() {
        return this.migrationState.isStsPluginInstalled() && !this.migrationState.isNotificationMuted();
    }
}

