/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.binding;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingutils.binding.Property;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.util.Arrays;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.osgi.util.NLS;

public final class Validators {
    private Validators() {
    }

    public static Validator<File> requiredDirectoryValidator(final String prefix) {
        return new Validator<File>(){

            public Optional<String> validate(File file) {
                if (file == null) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)prefix));
                }
                if (!file.exists()) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_DoesNotExist, (Object)prefix));
                }
                if (!file.isDirectory()) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeDirectory, (Object)prefix));
                }
                return Optional.absent();
            }
        };
    }

    public static Validator<File> optionalDirectoryValidator(final String prefix) {
        return new Validator<File>(){

            public Optional<String> validate(File file) {
                if (file == null) {
                    return Optional.absent();
                }
                if (!file.exists()) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_DoesNotExist, (Object)prefix));
                }
                if (!file.isDirectory()) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeDirectory, (Object)prefix));
                }
                return Optional.absent();
            }
        };
    }

    public static Validator<File> nonExistentDirectoryValidator(final String prefix) {
        return new Validator<File>(){

            public Optional<String> validate(File file) {
                if (file == null) {
                    return Optional.absent();
                }
                if (file.exists()) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_AlreadyExists, (Object)prefix));
                }
                return Optional.absent();
            }
        };
    }

    public static Validator<File> nonWorkspaceFolderValidator(final String prefix) {
        final File workspaceDir = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        return new Validator<File>(){

            public Optional<String> validate(File file) {
                if (workspaceDir.equals(file)) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_WorkspaceDirectory, (Object)prefix));
                }
                return Optional.absent();
            }
        };
    }

    public static Validator<String> uniqueWorkspaceProjectNameValidator(final String prefix) {
        return new Validator<String>(){

            public Optional<String> validate(String projectName) {
                if (Strings.isNullOrEmpty((String)projectName)) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_MustBeSpecified, (Object)prefix));
                }
                if (this.projectNameAlreadyExistsInWorkspace(projectName)) {
                    return Optional.of((Object)NLS.bind((String)CoreMessages.ErrorMessage_0_AlreadyExists, (Object)prefix));
                }
                return Optional.absent();
            }

            private boolean projectNameAlreadyExistsInWorkspace(final String projectName) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                return FluentIterable.from(Arrays.asList(projects)).anyMatch((Predicate)new Predicate<IProject>(){

                    public boolean apply(IProject project) {
                        return projectName.equals(project.getName());
                    }
                });
            }
        };
    }

    public static <T> Validator<T> validateIfConditionFalse(final Validator<T> validator, final Property<Boolean> condition) {
        return new Validator<T>(){

            public Optional<String> validate(T value) {
                return Boolean.FALSE.equals(condition.getValue()) ? validator.validate(value) : Optional.absent();
            }
        };
    }

    public static <T> Validator<T> and(final Validator<T> a, final Validator<T> b) {
        return new Validator<T>(){

            public Optional<String> validate(T value) {
                Optional result = a.validate(value);
                return result.isPresent() ? result : b.validate(value);
            }
        };
    }

    public static <T> Validator<T> nullValidator() {
        return new Validator<T>(){

            public Optional<String> validate(T value) {
                return Optional.absent();
            }
        };
    }
}

