/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingclient.BuildLaunchRequest;
import com.gradleware.tooling.toolingclient.BuildRequest;
import com.gradleware.tooling.toolingclient.LaunchableConfig;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.gradle.tooling.CancellationToken;

public class RunOnImportTasksOperation {
    private static final String WTP_TASK = "eclipseWtp";
    private static final String CLEAN_WTP_TASK = "cleanEclipseWtp";
    private static final String WTP_COMPONENT_NATURE = "org.eclipse.wst.common.modulecore.ModuleCoreNature";
    private final FixedRequestAttributes build;
    private final Set<OmniEclipseProject> allprojects;

    public RunOnImportTasksOperation(Set<OmniEclipseProject> allProjects, FixedRequestAttributes build) {
        this.allprojects = ImmutableSet.copyOf(allProjects);
        this.build = (FixedRequestAttributes)Preconditions.checkNotNull((Object)build);
    }

    public void run(IProgressMonitor monitor, CancellationToken token) throws CoreException {
        List<String> tasksToRun = this.findWtpTasks();
        if (!tasksToRun.isEmpty()) {
            this.runTasks(tasksToRun, monitor, token);
        }
    }

    private List<String> findWtpTasks() {
        if (!CorePlugin.workspaceOperations().isNatureRecognizedByEclipse(WTP_COMPONENT_NATURE)) {
            return Collections.emptyList();
        }
        HashSet cleanWtpTasks = Sets.newHashSet();
        HashSet wtpTasks = Sets.newHashSet();
        for (OmniEclipseProject eclipseProject : this.allprojects) {
            if (!this.isGradle30(eclipseProject) || !this.isWtpProject(eclipseProject) || this.isIncludedProject(eclipseProject)) continue;
            List tasks = eclipseProject.getGradleProject().getProjectTasks();
            for (OmniProjectTask task : tasks) {
                if (WTP_TASK.equals(task.getName())) {
                    wtpTasks.add(task.getPath().getPath());
                    continue;
                }
                if (!CLEAN_WTP_TASK.equals(task.getName())) continue;
                cleanWtpTasks.add(task.getPath().getPath());
            }
        }
        return ImmutableList.builder().addAll((Iterable)cleanWtpTasks).addAll((Iterable)wtpTasks).build();
    }

    private boolean isGradle30(OmniEclipseProject eclipseProject) {
        return eclipseProject.getClasspathContainers().isPresent();
    }

    private boolean isWtpProject(OmniEclipseProject eclipseProject) {
        Optional natures = eclipseProject.getProjectNatures();
        if (natures.isPresent()) {
            for (OmniEclipseProjectNature nature : (List)natures.get()) {
                if (!nature.getId().equals(WTP_COMPONENT_NATURE)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isIncludedProject(OmniEclipseProject eclipseProject) {
        File projectRoot;
        File buildRoot = this.build.getProjectDir();
        return !buildRoot.equals(projectRoot = eclipseProject.getProjectIdentifier().getBuildIdentifier().getRootDir());
    }

    private void runTasks(List<String> tasksToRun, IProgressMonitor monitor, CancellationToken token) {
        BuildLaunchRequest request = CorePlugin.toolingClient().newBuildLaunchRequest(LaunchableConfig.forTasks(tasksToRun));
        this.build.apply((BuildRequest)request);
        this.getTransientRequestAttributes(token, monitor).apply((Request)request);
        request.executeAndWait();
    }

    private TransientRequestAttributes getTransientRequestAttributes(CancellationToken token, IProgressMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents(monitor));
        ImmutableList noEventListeners = ImmutableList.of();
        return new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)progressListeners, (List)noEventListeners, token);
    }
}

