/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import java.util.Collections;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;

final class JavaSourceSettingsUpdater {
    public static void update(IJavaProject project, OmniEclipseProject modelProject, IProgressMonitor monitor) throws CoreException {
        OmniJavaSourceSettings sourceSettings = (OmniJavaSourceSettings)modelProject.getJavaSourceSettings().get();
        String sourceVersion = sourceSettings.getSourceLanguageLevel().getName();
        String targetVersion = sourceSettings.getTargetBytecodeLevel().getName();
        boolean compilerOptionChanged = false;
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.compliance", sourceVersion);
        compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.source", sourceVersion);
        if ((compilerOptionChanged |= JavaSourceSettingsUpdater.updateJavaProjectOptionIfNeeded(project, "org.eclipse.jdt.core.compiler.codegen.targetPlatform", targetVersion)) && JavaSourceSettingsUpdater.isProjectAutoBuildingEnabled()) {
            JavaSourceSettingsUpdater.scheduleJdtBuild(project.getProject());
        }
    }

    private static boolean updateJavaProjectOptionIfNeeded(IJavaProject project, String optionKey, String newValue) {
        String currentValue = project.getOption(optionKey, true);
        if (currentValue == null || !currentValue.equals(newValue)) {
            project.setOption(optionKey, newValue);
            return true;
        }
        return false;
    }

    private static boolean isProjectAutoBuildingEnabled() {
        return ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding();
    }

    private static void scheduleJdtBuild(final IProject project) {
        WorkspaceJob build = new WorkspaceJob(String.format("Building project %s after Java compiler settings changed", project.getName())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    if (project.isAccessible()) {
                        project.build(6, "org.eclipse.jdt.core.javabuilder", Collections.emptyMap(), monitor);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    monitor.done();
                }
            }

            public boolean belongsTo(Object family) {
                return family == ResourcesPlugin.FAMILY_AUTO_BUILD;
            }
        };
        build.schedule();
    }

    private JavaSourceSettingsUpdater() {
    }
}

