/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.concurrent;

import java.util.concurrent.atomic.AtomicReference;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExecutorPolicy {
    public void onExecute(Runnable var1);

    public void onStop();

    public static class CatchAndRecordFailures
    implements ExecutorPolicy {
        private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutorFactory.class);
        private final AtomicReference<Throwable> failure = new AtomicReference();

        public void onExecute(Runnable command) {
            try {
                command.run();
            }
            catch (Throwable throwable) {
                this.onFailure(String.format("Failed to execute %s.", command), throwable);
            }
        }

        public void onFailure(String message, Throwable throwable) {
            if (!this.failure.compareAndSet(null, throwable)) {
                LOGGER.error(message, throwable);
            }
        }

        public void onStop() {
            Throwable failure = this.failure.getAndSet(null);
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException(failure);
            }
        }
    }
}

