/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.collections.CollectionsUtils;
import org.eclipse.buildship.core.util.file.FileUtils;
import org.eclipse.buildship.core.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.util.file.DirectoryDialogSelectionListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class ProjectTab
extends AbstractLaunchConfigurationTab {
    private final Validator<File> workingDirValidator = Validators.requiredDirectoryValidator((String)CoreMessages.RunConfiguration_Label_WorkingDirectory);
    private Text tasksText;
    private Text workingDirectoryText;
    private Button showExecutionViewCheckbox;
    private Button showConsoleViewCheckbox;

    public String getName() {
        return LaunchMessages.Tab_Name_GradleTasks;
    }

    public Image getImage() {
        return PluginImages.RUN_CONFIG_TASKS.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void createControl(Composite root) {
        Composite parent = new Composite(root, 0);
        GridLayout layout = new GridLayout(1, false);
        parent.setLayout((Layout)layout);
        this.setControl((Control)parent);
        Group tasksGroup = this.createGroup(parent, CoreMessages.RunConfiguration_Label_GradleTasks + ":");
        this.createTasksSelectionControl((Composite)tasksGroup);
        Group workingDirectoryGroup = this.createGroup(parent, CoreMessages.RunConfiguration_Label_WorkingDirectory + ":");
        this.createWorkingDirectorySelectionControl((Composite)workingDirectoryGroup);
        Group buildExecutionGroup = this.createGroup(parent, CoreMessages.RunConfiguration_Label_BuildExecution + ":");
        this.createBuildExecutionControl((Composite)buildExecutionGroup);
    }

    private Group createGroup(Composite parent, String groupName) {
        Group group = new Group(parent, 0);
        group.setText(groupName);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        return group;
    }

    private void createTasksSelectionControl(Composite container) {
        this.tasksText = new Text(container, 2626);
        GridData tasksTextLayoutData = new GridData(4, 128, true, false, 1, 1);
        tasksTextLayoutData.heightHint = 50;
        this.tasksText.setLayoutData((Object)tasksTextLayoutData);
        this.tasksText.addModifyListener((ModifyListener)new DialogUpdater());
    }

    private void createWorkingDirectorySelectionControl(Composite container) {
        this.workingDirectoryText = new Text(container, 2052);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.workingDirectoryText.addModifyListener((ModifyListener)new DialogUpdater());
        Composite buttonContainer = new Composite(container, 0);
        GridLayout buttonContainerLayout = new GridLayout(3, false);
        buttonContainerLayout.marginHeight = 1;
        buttonContainerLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonContainerLayout);
        buttonContainer.setLayoutData((Object)new GridData(128));
        Button browseWorkspaceButton = new Button(buttonContainer, 0);
        browseWorkspaceButton.setText(LaunchMessages.Button_Label_BrowseWorkspace);
        browseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ListDialog projectDialog = new ListDialog(ProjectTab.this.getShell());
                projectDialog.setTitle(LaunchMessages.Title_BrowseWorkspaceDialog);
                projectDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider(){

                    public Object[] getElements(Object input) {
                        return ProjectTab.this.findAllGradleProjects();
                    }
                });
                projectDialog.setLabelProvider((ILabelProvider)new WorkbenchLabelProvider());
                projectDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                projectDialog.open();
                Object[] result = projectDialog.getResult();
                if (result != null) {
                    if (result.length > 0) {
                        String locationInExpression = ExpressionUtils.encodeWorkspaceLocation((IProject)((IProject)result[0]));
                        ProjectTab.this.workingDirectoryText.setText(locationInExpression);
                    } else {
                        ProjectTab.this.workingDirectoryText.setText("");
                    }
                }
            }
        });
        Button browseFilesystemButton = new Button(buttonContainer, 0);
        browseFilesystemButton.setText(LaunchMessages.Button_Label_BrowseFilesystem);
        browseFilesystemButton.addSelectionListener((SelectionListener)new DirectoryDialogSelectionListener(this.getShell(), this.workingDirectoryText, LaunchMessages.Title_BrowseFileSystemDialog));
        Button selectVariableButton = new Button(buttonContainer, 0);
        selectVariableButton.setText(LaunchMessages.Button_Label_SelectVariables);
        selectVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(ProjectTab.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    ProjectTab.this.workingDirectoryText.insert(variable);
                }
            }
        });
    }

    private IProject[] findAllGradleProjects() {
        return (IProject[])FluentIterable.from((Iterable)CorePlugin.workspaceOperations().getAllProjects()).filter((Predicate)new Predicate<IProject>(){

            public boolean apply(IProject project) {
                return GradleProjectNature.isPresentOn((IProject)project);
            }
        }).toArray(IProject.class);
    }

    private void createBuildExecutionControl(Composite container) {
        this.showExecutionViewCheckbox = new Button(container, 32);
        this.showExecutionViewCheckbox.setText(CoreMessages.BuildExecution_Label_ShowExecutionView);
        this.showExecutionViewCheckbox.addSelectionListener((SelectionListener)new DialogUpdater());
        this.showConsoleViewCheckbox = new Button(container, 32);
        this.showConsoleViewCheckbox.setText(CoreMessages.BuildExecution_Label_ShowConsoleView);
        this.showConsoleViewCheckbox.addSelectionListener((SelectionListener)new DialogUpdater());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        GradleRunConfigurationAttributes configurationAttributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.tasksText.setText(CollectionsUtils.joinWithSpace((List)configurationAttributes.getTasks()));
        this.workingDirectoryText.setText(Strings.nullToEmpty((String)configurationAttributes.getWorkingDirExpression()));
        this.showExecutionViewCheckbox.setSelection(configurationAttributes.isShowExecutionView());
        this.showConsoleViewCheckbox.setSelection(configurationAttributes.isShowConsoleView());
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyTasks((List)CollectionsUtils.splitBySpace((String)this.tasksText.getText()), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyWorkingDirExpression((String)this.workingDirectoryText.getText(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyShowExecutionView((boolean)this.showExecutionViewCheckbox.getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyShowConsoleView((boolean)this.showConsoleViewCheckbox.getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        String workingDirectoryResolved;
        String workingDirectoryExpression = this.workingDirectoryText.getText();
        try {
            workingDirectoryResolved = ExpressionUtils.decode((String)workingDirectoryExpression);
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)LaunchMessages.ErrorMessage_CannotResolveExpression_0, (Object)workingDirectoryExpression));
            return false;
        }
        File workingDir = (File)FileUtils.getAbsoluteFile((String)workingDirectoryResolved).orNull();
        Optional error = this.workingDirValidator.validate((Object)workingDir);
        this.setErrorMessage((String)error.orNull());
        return !error.isPresent();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private class DialogUpdater
    extends SelectionAdapter
    implements ModifyListener {
        private DialogUpdater() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            ProjectTab.this.updateLaunchConfigurationDialog();
        }
    }
}

