/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch.internal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.launch.internal.SupportedLaunchConfigType;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;

public abstract class LaunchConfigurationScope {
    public static final LaunchConfigurationScope INCLUDE_ALL = new IncludeAllLaunchConfigurationScope();

    public abstract boolean isEntryIncluded(IClasspathEntry var1);

    public static LaunchConfigurationScope from(ILaunchConfiguration configuration) {
        HashSet result = Sets.newHashSet();
        try {
            Set<IPackageFragmentRoot> soureFolders = SupportedLaunchConfigType.collectSourceFolders(configuration);
            for (IPackageFragmentRoot sourceFolder : soureFolders) {
                Set<String> scope = LaunchConfigurationScope.scopesFor(sourceFolder.getRawClasspathEntry());
                if (scope == null) {
                    return INCLUDE_ALL;
                }
                result.addAll(scope);
            }
            return new FilteringLaunchConfigurationScope(result);
        }
        catch (CoreException e) {
            CorePlugin.logger().warn("Cannot collect dependency scope information for launch configuration " + configuration.getName(), e);
            return INCLUDE_ALL;
        }
    }

    private static Set<String> scopesFor(IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!attribute.getName().equals("gradle_scope")) continue;
            return Sets.newHashSet((Object[])attribute.getValue().split(","));
        }
        return null;
    }

    private static Set<String> usedByScopesFor(IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!attribute.getName().equals("gradle_used_by_scope")) continue;
            return Sets.newHashSet((Object[])attribute.getValue().split(","));
        }
        return null;
    }

    private static final class FilteringLaunchConfigurationScope
    extends LaunchConfigurationScope {
        private final Set<String> scopes;

        public FilteringLaunchConfigurationScope(Set<String> scopes) {
            this.scopes = scopes;
        }

        @Override
        public boolean isEntryIncluded(IClasspathEntry entry) {
            if (this.scopes == null || this.scopes.isEmpty()) {
                return true;
            }
            Set entryUsedByScopes = LaunchConfigurationScope.usedByScopesFor(entry);
            if (entryUsedByScopes == null || entryUsedByScopes.isEmpty()) {
                return true;
            }
            return !Sets.intersection(this.scopes, (Set)entryUsedByScopes).isEmpty();
        }
    }

    private static final class IncludeAllLaunchConfigurationScope
    extends LaunchConfigurationScope {
        private IncludeAllLaunchConfigurationScope() {
        }

        @Override
        public boolean isEntryIncluded(IClasspathEntry entry) {
            return true;
        }
    }
}

