/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.OmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.OmniExternalDependency;
import com.gradleware.tooling.toolingmodel.OmniJavaRuntime;
import com.gradleware.tooling.toolingmodel.OmniJavaSourceSettings;
import com.gradleware.tooling.toolingmodel.OmniJavaVersion;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseBuildCommand;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseLinkedResource;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProjectDependency;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseProjectNature;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniEclipseSourceDirectory;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniExternalDependency;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniJavaRuntime;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniJavaSourceSettings;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniJavaVersion;
import com.gradleware.tooling.toolingmodel.repository.internal.HierarchyHelper;
import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.gradle.api.JavaVersion;
import org.gradle.api.specs.Spec;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseBuildCommand;
import org.gradle.tooling.model.eclipse.EclipseJavaSourceSettings;
import org.gradle.tooling.model.eclipse.EclipseLinkedResource;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.eclipse.EclipseProjectNature;
import org.gradle.tooling.model.eclipse.EclipseSourceDirectory;
import org.gradle.tooling.model.java.InstalledJdk;

public final class DefaultOmniEclipseProject
implements OmniEclipseProject {
    private final HierarchyHelper<OmniEclipseProject> hierarchyHelper;
    private String name;
    private String description;
    private Path path;
    private File projectDirectory;
    private ImmutableList<OmniEclipseProjectDependency> projectDependencies;
    private ImmutableList<OmniExternalDependency> externalDependencies;
    private ImmutableList<OmniEclipseLinkedResource> linkedResources;
    private ImmutableList<OmniEclipseSourceDirectory> sourceDirectories;
    private Optional<List<OmniEclipseProjectNature>> projectNatures;
    private Optional<List<OmniEclipseBuildCommand>> buildCommands;
    private Optional<OmniJavaSourceSettings> javaSourceSettings;

    private DefaultOmniEclipseProject(Comparator<? super OmniEclipseProject> comparator) {
        this.hierarchyHelper = new HierarchyHelper<DefaultOmniEclipseProject>(this, (Comparator)Preconditions.checkNotNull(comparator));
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    private void setPath(Path path) {
        this.path = path;
    }

    @Override
    public File getProjectDirectory() {
        return this.projectDirectory;
    }

    private void setProjectDirectory(File projectDirectory) {
        this.projectDirectory = projectDirectory;
    }

    public ImmutableList<OmniEclipseProjectDependency> getProjectDependencies() {
        return this.projectDependencies;
    }

    private void setProjectDependencies(List<OmniEclipseProjectDependency> projectDependencies) {
        this.projectDependencies = ImmutableList.copyOf(projectDependencies);
    }

    public ImmutableList<OmniExternalDependency> getExternalDependencies() {
        return this.externalDependencies;
    }

    private void setExternalDependencies(List<OmniExternalDependency> externalDependencies) {
        this.externalDependencies = ImmutableList.copyOf(externalDependencies);
    }

    public ImmutableList<OmniEclipseLinkedResource> getLinkedResources() {
        return this.linkedResources;
    }

    private void setLinkedResources(List<OmniEclipseLinkedResource> linkedResources) {
        this.linkedResources = ImmutableList.copyOf(linkedResources);
    }

    public ImmutableList<OmniEclipseSourceDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    private void setSourceDirectories(List<OmniEclipseSourceDirectory> sourceDirectories) {
        this.sourceDirectories = ImmutableList.copyOf(sourceDirectories);
    }

    @Override
    public Optional<List<OmniEclipseProjectNature>> getProjectNatures() {
        return this.projectNatures;
    }

    private void setProjectNatures(Optional<List<OmniEclipseProjectNature>> projectNatures) {
        this.projectNatures = projectNatures.isPresent() ? Optional.of((Object)ImmutableList.copyOf((Collection)((Collection)projectNatures.get()))) : Optional.absent();
    }

    @Override
    public Optional<List<OmniEclipseBuildCommand>> getBuildCommands() {
        return this.buildCommands;
    }

    private void setBuildCommands(Optional<List<OmniEclipseBuildCommand>> buildCommands) {
        this.buildCommands = buildCommands.isPresent() ? Optional.of((Object)ImmutableList.copyOf((Collection)((Collection)buildCommands.get()))) : Optional.absent();
    }

    @Override
    public Optional<OmniJavaSourceSettings> getJavaSourceSettings() {
        return this.javaSourceSettings;
    }

    private void setJavaSourceSettings(Optional<OmniJavaSourceSettings> javaSourceSettings) {
        this.javaSourceSettings = javaSourceSettings;
    }

    @Override
    public OmniEclipseProject getRoot() {
        return this.hierarchyHelper.getRoot();
    }

    @Override
    public OmniEclipseProject getParent() {
        return this.hierarchyHelper.getParent();
    }

    private void setParent(DefaultOmniEclipseProject parent) {
        this.hierarchyHelper.setParent(parent);
    }

    @Override
    public ImmutableList<OmniEclipseProject> getChildren() {
        return this.hierarchyHelper.getChildren();
    }

    private void addChild(DefaultOmniEclipseProject child) {
        child.setParent(this);
        this.hierarchyHelper.addChild(child);
    }

    @Override
    public ImmutableList<OmniEclipseProject> getAll() {
        return this.hierarchyHelper.getAll();
    }

    @Override
    public ImmutableList<OmniEclipseProject> filter(Spec<? super OmniEclipseProject> predicate) {
        return this.hierarchyHelper.filter(predicate);
    }

    @Override
    public Optional<OmniEclipseProject> tryFind(Spec<? super OmniEclipseProject> predicate) {
        return this.hierarchyHelper.tryFind(predicate);
    }

    public static DefaultOmniEclipseProject from(EclipseProject project) {
        DefaultOmniEclipseProject eclipseProject = new DefaultOmniEclipseProject(OmniEclipseProjectComparator.INSTANCE);
        eclipseProject.setName(project.getName());
        eclipseProject.setDescription(project.getDescription());
        eclipseProject.setPath(Path.from(project.getGradleProject().getPath()));
        eclipseProject.setProjectDirectory(project.getProjectDirectory());
        eclipseProject.setProjectDependencies((List<OmniEclipseProjectDependency>)DefaultOmniEclipseProject.toProjectDependencies((DomainObjectSet<? extends EclipseProjectDependency>)project.getProjectDependencies()));
        eclipseProject.setExternalDependencies((List<OmniExternalDependency>)DefaultOmniEclipseProject.toExternalDependencies((DomainObjectSet<? extends ExternalDependency>)project.getClasspath()));
        eclipseProject.setLinkedResources((List<OmniEclipseLinkedResource>)DefaultOmniEclipseProject.toLinkedResources((DomainObjectSet<? extends EclipseLinkedResource>)project.getLinkedResources()));
        eclipseProject.setSourceDirectories((List<OmniEclipseSourceDirectory>)DefaultOmniEclipseProject.toSourceDirectories((DomainObjectSet<? extends EclipseSourceDirectory>)project.getSourceDirectories()));
        DefaultOmniEclipseProject.setProjectNatures(eclipseProject, project);
        DefaultOmniEclipseProject.setBuildCommands(eclipseProject, project);
        DefaultOmniEclipseProject.setJavaSourceSettings(eclipseProject, project);
        for (EclipseProject child : project.getChildren()) {
            DefaultOmniEclipseProject eclipseChildProject = DefaultOmniEclipseProject.from(child);
            eclipseProject.addChild(eclipseChildProject);
        }
        return eclipseProject;
    }

    private static ImmutableList<OmniEclipseProjectDependency> toProjectDependencies(DomainObjectSet<? extends EclipseProjectDependency> projectDependencies) {
        return FluentIterable.from(projectDependencies).transform((Function)new Function<EclipseProjectDependency, OmniEclipseProjectDependency>(){

            public OmniEclipseProjectDependency apply(EclipseProjectDependency input) {
                return DefaultOmniEclipseProjectDependency.from(input);
            }
        }).toList();
    }

    private static ImmutableList<OmniExternalDependency> toExternalDependencies(DomainObjectSet<? extends ExternalDependency> externalDependencies) {
        return FluentIterable.from(externalDependencies).filter((Predicate)new Predicate<ExternalDependency>(){

            public boolean apply(ExternalDependency input) {
                return input.getFile().exists();
            }
        }).transform((Function)new Function<ExternalDependency, OmniExternalDependency>(){

            public OmniExternalDependency apply(ExternalDependency input) {
                return DefaultOmniExternalDependency.from(input);
            }
        }).toList();
    }

    private static ImmutableList<OmniEclipseLinkedResource> toLinkedResources(DomainObjectSet<? extends EclipseLinkedResource> linkedResources) {
        return FluentIterable.from(linkedResources).transform((Function)new Function<EclipseLinkedResource, OmniEclipseLinkedResource>(){

            public OmniEclipseLinkedResource apply(EclipseLinkedResource input) {
                return DefaultOmniEclipseLinkedResource.from(input);
            }
        }).toList();
    }

    private static ImmutableList<OmniEclipseSourceDirectory> toSourceDirectories(DomainObjectSet<? extends EclipseSourceDirectory> sourceDirectories) {
        return FluentIterable.from(sourceDirectories).transform((Function)new Function<EclipseSourceDirectory, OmniEclipseSourceDirectory>(){

            public OmniEclipseSourceDirectory apply(EclipseSourceDirectory input) {
                return DefaultOmniEclipseSourceDirectory.from(input);
            }
        }).toList();
    }

    private static void setProjectNatures(DefaultOmniEclipseProject eclipseProject, EclipseProject project) {
        try {
            ImmutableList<OmniEclipseProjectNature> projectNatures = DefaultOmniEclipseProject.toProjectNatures((DomainObjectSet<? extends EclipseProjectNature>)project.getProjectNatures());
            eclipseProject.setProjectNatures((Optional<List<OmniEclipseProjectNature>>)Optional.of(projectNatures));
        }
        catch (Exception ignore) {
            eclipseProject.setProjectNatures((Optional<List<OmniEclipseProjectNature>>)Optional.absent());
        }
    }

    private static ImmutableList<OmniEclipseProjectNature> toProjectNatures(DomainObjectSet<? extends EclipseProjectNature> projectNatures) {
        return FluentIterable.from(projectNatures).transform((Function)new Function<EclipseProjectNature, OmniEclipseProjectNature>(){

            public OmniEclipseProjectNature apply(EclipseProjectNature input) {
                return DefaultOmniEclipseProjectNature.from(input);
            }
        }).toList();
    }

    private static void setBuildCommands(DefaultOmniEclipseProject eclipseProject, EclipseProject project) {
        try {
            ImmutableList<OmniEclipseBuildCommand> buildCommands = DefaultOmniEclipseProject.toBuildCommands((DomainObjectSet<? extends EclipseBuildCommand>)project.getBuildCommands());
            eclipseProject.setBuildCommands((Optional<List<OmniEclipseBuildCommand>>)Optional.of(buildCommands));
        }
        catch (Exception ignore) {
            eclipseProject.setBuildCommands((Optional<List<OmniEclipseBuildCommand>>)Optional.absent());
        }
    }

    private static ImmutableList<OmniEclipseBuildCommand> toBuildCommands(DomainObjectSet<? extends EclipseBuildCommand> buildCommands) {
        return FluentIterable.from(buildCommands).transform((Function)new Function<EclipseBuildCommand, OmniEclipseBuildCommand>(){

            public OmniEclipseBuildCommand apply(EclipseBuildCommand input) {
                return DefaultOmniEclipseBuildCommand.from(input);
            }
        }).toList();
    }

    private static void setJavaSourceSettings(DefaultOmniEclipseProject eclipseProject, EclipseProject project) {
        try {
            EclipseJavaSourceSettings sourceSettings = project.getJavaSourceSettings();
            Optional javaSourceSettings = sourceSettings != null ? Optional.of((Object)DefaultOmniEclipseProject.toOmniJavaSourceSettings(sourceSettings)) : Optional.absent();
            eclipseProject.setJavaSourceSettings((Optional<OmniJavaSourceSettings>)javaSourceSettings);
        }
        catch (Exception ignore) {
            DefaultOmniEclipseProject.setCompatibilityJavaSourceSettings(eclipseProject);
        }
    }

    private static OmniJavaSourceSettings toOmniJavaSourceSettings(EclipseJavaSourceSettings javaSourceSettings) {
        OmniJavaRuntime targetRuntime;
        OmniJavaVersion targetBytecodeLevel;
        OmniJavaVersion sourceLanguageLevel = DefaultOmniEclipseProject.toOmniJavaVersion(javaSourceSettings.getSourceLanguageLevel());
        try {
            targetBytecodeLevel = DefaultOmniEclipseProject.toOmniJavaVersion(javaSourceSettings.getTargetBytecodeVersion());
        }
        catch (Exception ignore) {
            targetBytecodeLevel = sourceLanguageLevel;
        }
        try {
            targetRuntime = DefaultOmniEclipseProject.toOmniJavaRuntime(javaSourceSettings.getJdk());
        }
        catch (Exception ignore) {
            targetRuntime = DefaultOmniEclipseProject.getCompatibilityJavaRuntime();
        }
        return DefaultOmniJavaSourceSettings.from(sourceLanguageLevel, targetBytecodeLevel, targetRuntime);
    }

    private static void setCompatibilityJavaSourceSettings(DefaultOmniEclipseProject eclipseProject) {
        if (eclipseProject.getSourceDirectories().isEmpty()) {
            eclipseProject.setJavaSourceSettings((Optional<OmniJavaSourceSettings>)Optional.absent());
        } else {
            DefaultOmniJavaVersion languageLevel = DefaultOmniEclipseProject.getCompatibilityLanguageLevel();
            OmniJavaRuntime javaRuntime = DefaultOmniEclipseProject.getCompatibilityJavaRuntime();
            DefaultOmniJavaSourceSettings javaSourceSettings = DefaultOmniJavaSourceSettings.from(languageLevel, languageLevel, javaRuntime);
            eclipseProject.setJavaSourceSettings((Optional<OmniJavaSourceSettings>)Optional.of((Object)javaSourceSettings));
        }
    }

    private static DefaultOmniJavaVersion getCompatibilityLanguageLevel() {
        return DefaultOmniJavaVersion.from(JavaVersion.current());
    }

    private static OmniJavaRuntime getCompatibilityJavaRuntime() {
        return DefaultOmniJavaRuntime.from(JavaVersion.current(), new File(System.getProperty("java.home")).getAbsoluteFile());
    }

    private static OmniJavaRuntime toOmniJavaRuntime(InstalledJdk jdk) {
        return DefaultOmniJavaRuntime.from(jdk.getJavaVersion(), jdk.getJavaHome());
    }

    private static OmniJavaVersion toOmniJavaVersion(JavaVersion javaVersion) {
        return DefaultOmniJavaVersion.from(javaVersion);
    }

    private static enum OmniEclipseProjectComparator implements Comparator<OmniEclipseProject>
    {
        INSTANCE;


        @Override
        public int compare(OmniEclipseProject o1, OmniEclipseProject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    }
}

