/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.gradle.jarjar.com.google.common.collect.ArrayListMultimap;
import org.gradle.jarjar.com.google.common.collect.Lists;
import org.gradle.jarjar.com.google.common.collect.Multimap;
import org.gradle.jarjar.com.google.common.collect.Sets;
import org.gradle.tooling.internal.consumer.converters.ConsumerProvidedBuildInvocations;
import org.gradle.tooling.internal.consumer.converters.TaskNameComparator;
import org.gradle.tooling.internal.gradle.ConsumerProvidedTask;
import org.gradle.tooling.internal.gradle.ConsumerProvidedTaskSelector;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildInvocationsConverter {
    public ConsumerProvidedBuildInvocations convert(GradleProject project) {
        GradleProject rootProject = project;
        while (rootProject.getParent() != null) {
            rootProject = rootProject.getParent();
        }
        List<ConsumerProvidedTaskSelector> selectors = this.buildRecursively(rootProject);
        return new ConsumerProvidedBuildInvocations(selectors, this.convertTasks(rootProject.getTasks()));
    }

    private List<ConsumerProvidedTaskSelector> buildRecursively(GradleProject project) {
        ArrayListMultimap<String, String> aggregatedTasks = ArrayListMultimap.create();
        this.collectTasks(project, aggregatedTasks);
        ArrayList<ConsumerProvidedTaskSelector> selectors = Lists.newArrayList();
        for (String selectorName : aggregatedTasks.keySet()) {
            TreeSet<String> selectorTasks = Sets.newTreeSet(new TaskNameComparator());
            selectorTasks.addAll(aggregatedTasks.get(selectorName));
            selectors.add(new ConsumerProvidedTaskSelector().setName(selectorName).setTaskNames(selectorTasks).setDescription(project.getParent() != null ? String.format("%s:%s task selector", project.getPath(), selectorName) : String.format("%s task selector", selectorName)).setDisplayName(String.format("%s in %s and subprojects.", selectorName, project.getName())));
        }
        return selectors;
    }

    private void collectTasks(GradleProject project, Multimap<String, String> aggregatedTasks) {
        for (GradleProject gradleProject : project.getChildren()) {
            this.collectTasks(gradleProject, aggregatedTasks);
        }
        for (GradleTask gradleTask : project.getTasks()) {
            aggregatedTasks.put(gradleTask.getName(), gradleTask.getPath());
        }
    }

    private List<ConsumerProvidedTask> convertTasks(Iterable<? extends GradleTask> tasks) {
        ArrayList<ConsumerProvidedTask> result = Lists.newArrayList();
        for (GradleTask gradleTask : tasks) {
            result.add(new ConsumerProvidedTask().setName(gradleTask.getName()).setPath(gradleTask.getPath()).setDescription(gradleTask.getDescription()));
        }
        return result;
    }
}

