/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.selection;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.ui.util.selection.SelectionUtils;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public final class ContextActivatingViewPartListener
implements IPartListener2 {
    private final IViewPart viewPart;
    private final String contextId;
    private final IContextService contextService;
    private IContextActivation activation;

    public ContextActivatingViewPartListener(String contextId, IViewPart viewPart) {
        this.viewPart = (IViewPart)Preconditions.checkNotNull((Object)viewPart);
        this.contextId = (String)Preconditions.checkNotNull((Object)contextId);
        this.contextService = (IContextService)viewPart.getSite().getService(IContextService.class);
        this.activation = null;
    }

    public void partActivated(IWorkbenchPartReference partReference) {
        if (SelectionUtils.belongsToViewPart(partReference, this.viewPart)) {
            this.activation = this.contextService.activateContext(this.contextId);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partReference) {
        if (SelectionUtils.belongsToViewPart(partReference, this.viewPart) && this.activation != null) {
            this.contextService.deactivateContext(this.activation);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

