/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingmodel.OmniEclipseLinkedResource;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

final class LinkedResourcesUpdater {
    private static final String LINKED_RESOURCE_TYPE_FOLDER = "2";
    private static final QualifiedName RESOURCE_PROPERTY_FROM_GRADLE_MODEL = new QualifiedName("org.eclipse.buildship.core", "FROM_GRADLE_MODEL");
    private final IProject project;
    private final List<OmniEclipseLinkedResource> linkedResources;

    private LinkedResourcesUpdater(IProject project, List<OmniEclipseLinkedResource> linkedResources) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.linkedResources = (List)Preconditions.checkNotNull(linkedResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLinkedResources(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Update linked resources", -1);
        try {
            this.removeOldLinkedResources();
            this.updateExistingLinkedResources();
            this.createNewLinkedResources();
        }
        finally {
            monitor.done();
        }
    }

    private void removeOldLinkedResources() throws CoreException {
        List<IFolder> folders = this.collectLinkedFoldersNoLongerInGradleModel();
        LinkedResourcesUpdater.deleteFolders(folders);
    }

    private void updateExistingLinkedResources() throws CoreException {
        List<IFolder> folders = this.collectLinkedFoldersDefinedManuallyAndAlsoInGradleModel();
        this.markFoldersFromGradleModel(folders);
    }

    private List<IFolder> collectLinkedFoldersNoLongerInGradleModel() throws CoreException {
        return FluentIterable.from(Arrays.asList(this.project.members())).filter(IFolder.class).filter((Predicate)new Predicate<IFolder>(){

            public boolean apply(IFolder folder) {
                return folder.isLinked() && folder.getLocation() != null && !LinkedResourcesUpdater.this.isLocationPartOfCurrentGradleModel(folder.getLocation().toFile()) && LinkedResourcesUpdater.this.isFromGradleModel(folder);
            }
        }).toList();
    }

    private List<IFolder> collectLinkedFoldersDefinedManuallyAndAlsoInGradleModel() throws CoreException {
        return FluentIterable.from(Arrays.asList(this.project.members())).filter(IFolder.class).filter((Predicate)new Predicate<IFolder>(){

            public boolean apply(IFolder folder) {
                return folder.isLinked() && folder.getLocation() != null && LinkedResourcesUpdater.this.isLocationPartOfCurrentGradleModel(folder.getLocation().toFile());
            }
        }).toList();
    }

    private boolean isLocationPartOfCurrentGradleModel(final File location) {
        return FluentIterable.from(this.linkedResources).firstMatch((Predicate)new Predicate<OmniEclipseLinkedResource>(){

            public boolean apply(OmniEclipseLinkedResource linkedResource) {
                return LinkedResourcesUpdater.this.isLinkedResourceFolder(linkedResource) && location.equals(new File(linkedResource.getLocation()));
            }
        }).isPresent();
    }

    private boolean isFromGradleModel(IFolder folder) {
        try {
            return ((String)Optional.fromNullable((Object)folder.getPersistentProperty(RESOURCE_PROPERTY_FROM_GRADLE_MODEL)).or((Object)"false")).equals("true");
        }
        catch (CoreException e) {
            return false;
        }
    }

    private void markFoldersFromGradleModel(List<IFolder> folders) throws CoreException {
        for (IFolder folder : folders) {
            this.markFolderFromGradleModel(folder);
        }
    }

    private void markFolderFromGradleModel(IFolder folder) throws CoreException {
        folder.setPersistentProperty(RESOURCE_PROPERTY_FROM_GRADLE_MODEL, "true");
    }

    private void createNewLinkedResources() throws CoreException {
        Set<File> currentLinkedFolders = this.collectCurrentLinkedFolders();
        List<OmniEclipseLinkedResource> newLinkedResources = this.collectNewLinkedResources(currentLinkedFolders);
        this.createLinkedResources(newLinkedResources);
    }

    private Set<File> collectCurrentLinkedFolders() throws CoreException {
        return FluentIterable.from(Arrays.asList(this.project.members())).filter(IFolder.class).filter((Predicate)new Predicate<IFolder>(){

            public boolean apply(IFolder folder) {
                return folder.isLinked() && folder.getLocation() != null;
            }
        }).transform((Function)new Function<IFolder, File>(){

            public File apply(IFolder folder) {
                return folder.getLocation().toFile();
            }
        }).toSet();
    }

    private List<OmniEclipseLinkedResource> collectNewLinkedResources(final Set<File> currentLinkedFolders) throws CoreException {
        return FluentIterable.from(this.linkedResources).filter((Predicate)new Predicate<OmniEclipseLinkedResource>(){

            public boolean apply(OmniEclipseLinkedResource linkedResource) {
                return LinkedResourcesUpdater.this.isLinkedResourceFolder(linkedResource) && !currentLinkedFolders.contains(new File(linkedResource.getLocation()));
            }
        }).toList();
    }

    private void createLinkedResources(List<OmniEclipseLinkedResource> linkedResources) throws CoreException {
        for (OmniEclipseLinkedResource linkedResource : linkedResources) {
            Path resourcePath = new Path(linkedResource.getLocation());
            IFolder folder = this.toNewFolder(linkedResource.getName());
            folder.createLink((IPath)resourcePath, 0, null);
            this.markFolderFromGradleModel(folder);
        }
    }

    private IFolder toNewFolder(String folderName) throws CoreException {
        IFolder folder = this.project.getFolder(folderName);
        if (folder.exists()) {
            return this.toNewFolder(folderName + "_");
        }
        return folder;
    }

    private boolean isLinkedResourceFolder(OmniEclipseLinkedResource linkedResource) {
        return linkedResource.getLocation() != null && linkedResource.getType().equals(LINKED_RESOURCE_TYPE_FOLDER);
    }

    private static void deleteFolders(List<IFolder> folders) throws CoreException {
        for (IFolder folder : folders) {
            folder.delete(false, null);
        }
    }

    public static void update(IProject project, List<OmniEclipseLinkedResource> linkedResources, IProgressMonitor monitor) throws CoreException {
        LinkedResourcesUpdater updater = new LinkedResourcesUpdater(project, linkedResources);
        updater.updateLinkedResources(monitor);
    }
}

