/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class SynchronizeGradleProjectJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes rootRequestAttributes;
    private final ImmutableList<String> workingSets;
    private final AsyncHandler initializer;

    public SynchronizeGradleProjectJob(FixedRequestAttributes rootRequestAttributes, List<String> workingSets, AsyncHandler initializer) {
        super(String.format("Synchronize Gradle root project at %s with workspace", ((FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes)).getProjectDir().getAbsolutePath()), false);
        this.rootRequestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes);
        this.workingSets = ImmutableList.copyOf(workingSets);
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) {
        monitor.beginTask(String.format("Synchronizing Gradle root project at %s with workspace", this.rootRequestAttributes.getProjectDir().getAbsolutePath()), 100);
        this.initializer.run((IProgressMonitor)new SubProgressMonitor(monitor, 10), this.getToken());
        IJobManager manager = Job.getJobManager();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
        try {
            OmniEclipseGradleBuild gradleBuild = this.forceReloadEclipseGradleBuild(this.rootRequestAttributes, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
            CorePlugin.workspaceGradleOperations().synchronizeGradleBuildWithWorkspace(gradleBuild, this.rootRequestAttributes, (List<String>)this.workingSets, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
        }
        finally {
            manager.endRule((ISchedulingRule)workspaceRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OmniEclipseGradleBuild forceReloadEclipseGradleBuild(FixedRequestAttributes requestAttributes, IProgressMonitor monitor) {
        monitor.beginTask(String.format("Force reload of Gradle root project at %s", requestAttributes.getProjectDir().getAbsolutePath()), -1);
        try {
            ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
            ImmutableList listeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
            TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)listeners, (List)ImmutableList.of(), this.getToken());
            ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(requestAttributes);
            OmniEclipseGradleBuild omniEclipseGradleBuild = repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
            return omniEclipseGradleBuild;
        }
        finally {
            monitor.done();
        }
    }

    public boolean belongsTo(Object family) {
        return SynchronizeGradleProjectJob.class.getName().equals(family);
    }
}

