/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;

public final class ProjectConfiguration {
    private final FixedRequestAttributes requestAttributes;
    private final Path projectPath;
    private final File projectDir;

    private ProjectConfiguration(FixedRequestAttributes requestAttributes, Path projectPath, File projectDir) {
        this.requestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)requestAttributes);
        this.projectPath = (Path)Preconditions.checkNotNull((Object)projectPath);
        this.projectDir = (File)Preconditions.checkNotNull((Object)projectDir);
    }

    public FixedRequestAttributes getRequestAttributes() {
        return this.requestAttributes;
    }

    public Path getProjectPath() {
        return this.projectPath;
    }

    public File getProjectDir() {
        return this.projectDir;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ProjectConfiguration that = (ProjectConfiguration)other;
        return Objects.equal((Object)this.requestAttributes, (Object)that.requestAttributes) && Objects.equal((Object)this.projectDir, (Object)that.projectDir) && Objects.equal((Object)this.projectPath, (Object)that.projectPath);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.requestAttributes, this.projectDir, this.projectPath});
    }

    public static ProjectConfiguration from(FixedRequestAttributes requestAttributes, OmniEclipseProject project) {
        return ProjectConfiguration.from(requestAttributes, project.getPath(), project.getProjectDirectory());
    }

    public static ProjectConfiguration from(FixedRequestAttributes requestAttributes, Path projectPath, File projectDir) {
        return new ProjectConfiguration(requestAttributes, projectPath, projectDir);
    }
}

