/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.ModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.gradle.Specs;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.internal.ClasspathContainerUpdater;
import org.eclipse.buildship.core.workspace.internal.LinkedResourcesUpdater;
import org.eclipse.buildship.core.workspace.internal.SourceFolderUpdater;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.gradle.tooling.CancellationToken;

public final class GradleClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject javaProject) {
        this.scheduleClasspathInitialization(javaProject);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject javaProject, IClasspathContainer containerSuggestion) {
        this.scheduleClasspathInitialization(javaProject);
    }

    private void scheduleClasspathInitialization(final IJavaProject project) {
        new ToolingApiWorkspaceJob("Initialize Gradle classpath for project '" + project.getElementName() + "'"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) throws Exception {
                monitor.beginTask("Initializing classpath", 100);
                IJobManager manager = Job.getJobManager();
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                manager.beginRule((ISchedulingRule)workspaceRoot, monitor);
                try {
                    GradleClasspathContainerInitializer.this.internalInitialize(project, monitor, this.getToken());
                }
                finally {
                    manager.endRule((ISchedulingRule)workspaceRoot);
                }
            }
        }.schedule();
    }

    private void internalInitialize(IJavaProject javaProject, IProgressMonitor monitor, CancellationToken token) throws CoreException {
        IProject project = javaProject.getProject();
        Optional<OmniEclipseProject> gradleProject = this.findEclipseProject(project, monitor, token);
        monitor.worked(70);
        if (gradleProject.isPresent()) {
            if (project.isAccessible()) {
                LinkedResourcesUpdater.update(project, ((OmniEclipseProject)gradleProject.get()).getLinkedResources(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                SourceFolderUpdater.update(javaProject, ((OmniEclipseProject)gradleProject.get()).getSourceDirectories(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                ClasspathContainerUpdater.update(javaProject, (OmniEclipseProject)gradleProject.get(), (IPath)new Path("org.eclipse.buildship.core.gradleclasspathcontainer"), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
        } else {
            throw new GradlePluginsRuntimeException(String.format("Cannot find Eclipse project model for project %s.", project));
        }
    }

    private Optional<OmniEclipseProject> findEclipseProject(IProject project, IProgressMonitor monitor, CancellationToken token) {
        ProjectConfiguration configuration = CorePlugin.projectConfigurationManager().readProjectConfiguration(project);
        OmniEclipseGradleBuild eclipseGradleBuild = this.fetchEclipseGradleBuild(configuration.getRequestAttributes(), monitor, token);
        return eclipseGradleBuild.getRootEclipseProject().tryFind(Specs.eclipseProjectMatchesProjectPath(configuration.getProjectPath()));
    }

    private OmniEclipseGradleBuild fetchEclipseGradleBuild(FixedRequestAttributes fixedRequestAttributes, IProgressMonitor monitor, CancellationToken token) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList progressListeners = ImmutableList.of((Object)new DelegatingProgressListener(monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), null, (List)progressListeners, (List)ImmutableList.of(), token);
        ModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(fixedRequestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.LOAD_IF_NOT_CACHED);
    }
}

