/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal;

import java.io.File;
import java.net.URI;
import org.gradle.tooling.composite.CompositeParticipant;
import org.gradle.tooling.composite.internal.dist.GradleDistribution;
import org.gradle.tooling.composite.internal.dist.InstalledGradleDistribution;
import org.gradle.tooling.composite.internal.dist.URILocatedGradleDistribution;
import org.gradle.tooling.composite.internal.dist.VersionBasedGradleDistribution;

public class DefaultCompositeParticipant
implements CompositeParticipant {
    private final File rootProjectDirectory;
    private GradleDistribution gradleDistribution;

    public DefaultCompositeParticipant(File rootProjectDirectory) {
        this.rootProjectDirectory = rootProjectDirectory;
    }

    @Override
    public File getRootProjectDirectory() {
        return this.rootProjectDirectory;
    }

    @Override
    public void useInstallation(File gradleHome) {
        this.gradleDistribution = new InstalledGradleDistribution(gradleHome);
    }

    @Override
    public void useGradleVersion(String gradleVersion) {
        this.gradleDistribution = new VersionBasedGradleDistribution(gradleVersion);
    }

    @Override
    public void useDistribution(URI location) {
        this.gradleDistribution = new URILocatedGradleDistribution(location);
    }

    GradleDistribution getDistribution() {
        return this.gradleDistribution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCompositeParticipant that = (DefaultCompositeParticipant)o;
        if (this.rootProjectDirectory != null ? !this.rootProjectDirectory.equals(that.rootProjectDirectory) : that.rootProjectDirectory != null) {
            return false;
        }
        return this.gradleDistribution != null ? this.gradleDistribution.equals(that.gradleDistribution) : that.gradleDistribution == null;
    }

    public int hashCode() {
        int result = this.rootProjectDirectory != null ? this.rootProjectDirectory.hashCode() : 0;
        result = 31 * result + (this.gradleDistribution != null ? this.gradleDistribution.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("root project dir: %s, Gradle distribution: %s", this.rootProjectDirectory, this.gradleDistribution);
    }

    void setGradleDistribution(GradleDistribution gradleDistribution) {
        this.gradleDistribution = gradleDistribution;
    }
}

