/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingutils.binding.Property;
import java.util.List;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.ui.wizard.project.AbstractWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectImportWizard;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class GradleWelcomeWizardPage
extends AbstractWizardPage {
    private final Font headerFont = this.createHeaderFont();

    public GradleWelcomeWizardPage(ProjectImportConfiguration configuration) {
        super("GradleWelcome", ProjectWizardMessages.Title_GradleWelcomeWizardPage, ProjectWizardMessages.InfoMessage_GradleWelcomeWizardPageDefault, configuration, (List<Property<?>>)ImmutableList.of());
    }

    private Font createHeaderFont() {
        FontData[] fontData;
        for (FontData font : fontData = JFaceResources.getDialogFont().getFontData()) {
            font.setHeight(18);
        }
        return new Font((Device)PlatformUI.getWorkbench().getDisplay(), fontData);
    }

    @Override
    protected void createWidgets(Composite root) {
        root.setLayout((Layout)new GridLayout(1, false));
        StyledText welcomeText = new StyledText(root, 16777282);
        GridData welcomeTextLayoutData = new GridData(0x1000000, 128, false, false, 1, 1);
        welcomeTextLayoutData.widthHint = 500;
        welcomeText.setLayoutData((Object)welcomeTextLayoutData);
        welcomeText.setBackground(welcomeText.getParent().getBackground());
        welcomeText.setEnabled(false);
        welcomeText.setEditable(false);
        this.fillWelcomeText(welcomeText);
        final Button showWelcomePageCheckbox = new Button(root, 32);
        showWelcomePageCheckbox.setText("Show welcome page next time the wizard appears");
        GridData showWelcomePageCheckboxLayoutData = new GridData(0x1000000, 1024, false, false, 1, 1);
        showWelcomePageCheckboxLayoutData.widthHint = welcomeTextLayoutData.widthHint;
        showWelcomePageCheckboxLayoutData.verticalIndent = 15;
        showWelcomePageCheckbox.setLayoutData((Object)showWelcomePageCheckboxLayoutData);
        showWelcomePageCheckbox.setSelection(((ProjectImportWizard)this.getWizard()).isShowWelcomePage());
        showWelcomePageCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((ProjectImportWizard)GradleWelcomeWizardPage.this.getWizard()).setWelcomePageEnabled(showWelcomePageCheckbox.getSelection());
            }
        });
    }

    private void fillWelcomeText(StyledText welcomeText) {
        String title = "How to experience the best Gradle integration";
        String paragraph1Title = "Smart project import";
        String paragraph2Title = "Gradle Wrapper";
        String paragraph3Title = "Advanced options";
        String paragraph1 = paragraph1Title + "\nPoint the wizard to the root location of the Gradle project to import. Buildship will take care of importing all the " + "belonging projects. All imported projects that already contain an Eclipse .project file will be left alone, aside from being added the Gradle nature.";
        String paragraph2 = paragraph2Title + "\nYou will experience the best Gradle integration if you make use of the Gradle wrapper in your Gradle build and configure it " + "to use the latest released version of Gradle. Using the Gradle wrapper also makes the build most sharable between multiple users.";
        String paragraph3 = paragraph3Title + "\nUnless you have a very specific reason, leave the advanced options at their default values. The advanced options can be useful " + "to quickly try different settings and see their impact on the import.";
        String welcome = title + "\n\n" + paragraph1 + "\n\n" + paragraph2 + "\n\n" + paragraph3;
        welcomeText.setText(welcome);
        welcomeText.setLineJustify(1, welcomeText.getLineCount() - 1, true);
        StyleRange titleStyle = new StyleRange();
        titleStyle.start = 0;
        titleStyle.length = title.length();
        titleStyle.font = this.headerFont;
        titleStyle.fontStyle = 1;
        welcomeText.setStyleRange(titleStyle);
        StyleRange paragraphStyle = new StyleRange();
        paragraphStyle.start = welcome.indexOf(paragraph1);
        paragraphStyle.length = paragraph1Title.length();
        paragraphStyle.fontStyle = 1;
        welcomeText.setStyleRange(paragraphStyle);
        paragraphStyle.start = welcome.indexOf(paragraph2);
        paragraphStyle.length = paragraph2Title.length();
        welcomeText.setStyleRange(paragraphStyle);
        paragraphStyle.start = welcome.indexOf(paragraph3);
        paragraphStyle.length = paragraph3Title.length();
        welcomeText.setStyleRange(paragraphStyle);
    }

    @Override
    protected String getPageContextInformation() {
        return ProjectWizardMessages.InfoMessage_GradleWelcomeWizardPageContext;
    }

    @Override
    public void dispose() {
        this.headerFont.dispose();
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        ((ProjectImportWizard)this.getWizard()).setFinishGloballyEnabled(!visible);
    }
}

