/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.RunConfiguration;
import org.eclipse.buildship.core.launch.RunGradleJvmTestLaunchRequestJob;
import org.eclipse.buildship.core.launch.TestMethod;
import org.eclipse.buildship.core.launch.TestTarget;
import org.eclipse.buildship.core.launch.TestType;
import org.eclipse.buildship.ui.launch.EditorJavaElementResolver;
import org.eclipse.buildship.ui.launch.JavaElementResolver;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.launch.SelectionJavaElementResolver;
import org.eclipse.buildship.ui.launch.TestLaunchShortcutValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class TestLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        SelectionJavaElementResolver resolver = SelectionJavaElementResolver.from(selection);
        this.launch(resolver);
    }

    public void launch(IEditorPart editor, String mode) {
        EditorJavaElementResolver resolver = EditorJavaElementResolver.from(editor);
        this.launch(resolver);
    }

    private void launch(JavaElementResolver resolver) {
        List<IMethod> methods;
        List<IType> types = resolver.resolveTypes();
        if (TestLaunchShortcutValidator.validateTypesAndMethods(types, methods = resolver.resolveMethods())) {
            ImmutableList.Builder targets = ImmutableList.builder();
            targets.addAll(TestLaunchShortcut.convertTypesToTestTargets(types));
            targets.addAll(TestLaunchShortcut.convertMethodsToTestTargets(methods));
            RunConfiguration runConfiguration = this.collectRunConfiguration((IProject)resolver.findFirstContainerProject().get());
            new RunGradleJvmTestLaunchRequestJob((List)targets.build(), runConfiguration).schedule();
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private RunConfiguration collectRunConfiguration(IProject project) {
        ProjectConfiguration projectConfig = CorePlugin.configurationManager().loadProjectConfiguration(project);
        BuildConfiguration buildConfig = projectConfig.getBuildConfiguration();
        return CorePlugin.configurationManager().createRunConfiguration(buildConfig, Collections.emptyList(), null, Collections.emptyList(), Collections.emptyList(), true, true, false, GradleDistribution.fromBuild(), null, false, false);
    }

    private void showNoTestsFoundDialog() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)LaunchMessages.Test_Not_Found_Dialog_Title, (String)String.format("%s%n%s", LaunchMessages.Test_Not_Found_Dialog_Message, LaunchMessages.Test_Not_Found_Dialog_Details));
            }
        });
    }

    private static List<TestTarget> convertTypesToTestTargets(Collection<IType> types) {
        return FluentIterable.from(types).transform((Function)new Function<IType, TestTarget>(){

            public TestTarget apply(IType type) {
                return TestType.from((IType)type);
            }
        }).toList();
    }

    private static List<TestTarget> convertMethodsToTestTargets(Collection<IMethod> methods) {
        return FluentIterable.from(methods).transform((Function)new Function<IMethod, TestTarget>(){

            public TestTarget apply(IMethod method) {
                return TestMethod.from((IMethod)method);
            }
        }).toList();
    }
}

