/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.util.gradle;

import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingutils.distribution.PublishedGradleVersions;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.util.GradleVersion;

public final class PublishedGradleVersionsWrapper {
    private final AtomicReference<PublishedGradleVersions> publishedGradleVersions = new AtomicReference();

    public PublishedGradleVersionsWrapper() {
        new LoadVersionsJob().schedule();
    }

    public List<GradleVersion> getVersions() {
        PublishedGradleVersions versions = this.publishedGradleVersions.get();
        return versions != null ? versions.getVersions() : ImmutableList.of((Object)GradleVersion.current());
    }

    private final class LoadVersionsJob
    extends Job {
        public LoadVersionsJob() {
            super("Loading available Gradle versions");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                PublishedGradleVersions versions = PublishedGradleVersions.create((PublishedGradleVersions.LookupStrategy)PublishedGradleVersions.LookupStrategy.REMOTE_IF_NOT_CACHED);
                PublishedGradleVersionsWrapper.this.publishedGradleVersions.set(versions);
            }
            catch (RuntimeException e) {
                CorePlugin.logger().warn("Could not load Gradle version information", e);
            }
            return Status.OK_STATUS;
        }

        protected void canceling() {
            Thread.currentThread().interrupt();
        }
    }
}

