/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSortedMap;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.OmniGradleProject;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocations;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.gradle.tooling.model.gradle.BuildInvocations;

public final class DefaultOmniBuildInvocationsContainer
implements OmniBuildInvocationsContainer {
    private final ImmutableSortedMap<Path, OmniBuildInvocations> buildInvocationsPerProject;

    private DefaultOmniBuildInvocationsContainer(SortedMap<Path, OmniBuildInvocations> buildInvocationsPerProject) {
        this.buildInvocationsPerProject = ImmutableSortedMap.copyOfSorted(buildInvocationsPerProject);
    }

    @Override
    public Optional<OmniBuildInvocations> get(Path projectPath) {
        return Optional.fromNullable((Object)this.buildInvocationsPerProject.get((Object)projectPath));
    }

    public ImmutableSortedMap<Path, OmniBuildInvocations> asMap() {
        return this.buildInvocationsPerProject;
    }

    public static OmniBuildInvocationsContainer from(Map<String, BuildInvocations> buildInvocationsPerProject) {
        ImmutableSortedMap.Builder buildInvocationsMap = ImmutableSortedMap.orderedBy((Comparator)Path.Comparator.INSTANCE);
        for (String projectPath : buildInvocationsPerProject.keySet()) {
            buildInvocationsMap.put((Object)Path.from(projectPath), (Object)DefaultOmniBuildInvocations.from(buildInvocationsPerProject.get(projectPath), Path.from(projectPath)));
        }
        return new DefaultOmniBuildInvocationsContainer((SortedMap<Path, OmniBuildInvocations>)buildInvocationsMap.build());
    }

    public static DefaultOmniBuildInvocationsContainer from(SortedMap<Path, OmniBuildInvocations> buildInvocationsPerProject) {
        return new DefaultOmniBuildInvocationsContainer(buildInvocationsPerProject);
    }

    public static OmniBuildInvocationsContainer from(OmniGradleProject gradleProject) {
        ImmutableSortedMap.Builder result = ImmutableSortedMap.orderedBy((Comparator)Path.Comparator.INSTANCE);
        DefaultOmniBuildInvocationsContainer.collectBuildInvocations(gradleProject, (ImmutableSortedMap.Builder<Path, OmniBuildInvocations>)result);
        return new DefaultOmniBuildInvocationsContainer((SortedMap<Path, OmniBuildInvocations>)result.build());
    }

    private static void collectBuildInvocations(OmniGradleProject project, ImmutableSortedMap.Builder<Path, OmniBuildInvocations> result) {
        result.put((Object)project.getPath(), (Object)DefaultOmniBuildInvocations.from(project.getProjectTasks(), project.getTaskSelectors()));
        List<OmniGradleProject> children = project.getChildren();
        for (OmniGradleProject child : children) {
            DefaultOmniBuildInvocationsContainer.collectBuildInvocations(child, result);
        }
    }
}

