/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.view;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.internal.view.Page;
import org.eclipse.buildship.ui.internal.view.PageSite;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.SubActionBars;
import org.eclipse.ui.part.ViewPart;

public abstract class MultiPageView
extends ViewPart {
    public static final String PAGE_GROUP = "pageGroup";
    public static final String PART_GROUP = "partGroup";
    private final List<Page> pages = new LinkedList<Page>();
    private Page currentPage = null;
    private Page defaultPage = null;
    private final PageSelectionProvider pageSelectionProvider = new PageSelectionProvider();
    private final ISelectionChangedListener selectionChangedListener = new ForwardingSelectionChangedListener(this.pageSelectionProvider);
    private final IPropertyChangeListener actionBarPropertyChangeListener = new ActionBarsPropertyChangeListener(this);
    private Composite stackComposite;
    private StackLayout stackLayout;

    protected MultiPageView() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.setSelectionProvider((ISelectionProvider)this.pageSelectionProvider);
        IToolBarManager toolBarManager = site.getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator(PAGE_GROUP));
        toolBarManager.add((IContributionItem)new Separator(PART_GROUP));
    }

    public final void createPartControl(Composite parent) {
        this.stackComposite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackComposite.setLayout((Layout)this.stackLayout);
        this.defaultPage = this.createDefaultPage();
        this.defaultPage.createPage(this.stackComposite);
        this.initPage(this.defaultPage);
        this.switchToPage(this.defaultPage);
        this.updateVisibilityOfGlobalActions();
    }

    protected abstract Page createDefaultPage();

    public void addPage(Page page) {
        int index = this.pages.indexOf(page);
        if (index != -1) {
            throw new GradlePluginsRuntimeException("Page already known: " + page.getDisplayName());
        }
        page.createPage(this.stackComposite);
        this.initPage(page);
        this.pages.add(page);
        this.updateVisibilityOfGlobalActions();
    }

    private void initPage(Page page) {
        DefaultPageSite pageSite = new DefaultPageSite(this.getViewSite());
        SubActionBars actionBars = (SubActionBars)pageSite.getActionBars();
        actionBars.addPropertyChangeListener(this.actionBarPropertyChangeListener);
        page.init(pageSite);
    }

    public void removePage(Page page) {
        int index = this.pages.indexOf(page);
        if (index == -1) {
            throw new GradlePluginsRuntimeException("Unknown page: " + page.getDisplayName());
        }
        page.getSite().dispose();
        page.dispose();
        this.pages.remove(index);
        this.updateVisibilityOfGlobalActions();
        if (this.hasPages()) {
            this.switchToPageAtIndex(Math.min(index, this.pages.size() - 1));
        } else {
            this.switchToPage(this.defaultPage);
        }
    }

    public void removeAllPages() {
        Iterator<Page> iterator = this.pages.iterator();
        while (iterator.hasNext()) {
            Page page = iterator.next();
            page.getSite().dispose();
            page.dispose();
            iterator.remove();
        }
        this.updateVisibilityOfGlobalActions();
        this.switchToPage(this.defaultPage);
    }

    public void switchToNextPage() {
        if (this.hasPages()) {
            int nextPage = (this.pages.indexOf(this.getCurrentPage()) + 1) % this.pages.size();
            this.switchToPageAtIndex(nextPage);
        }
    }

    public void switchToPageAtIndex(int index) {
        if (index < 0 && index >= this.pages.size()) {
            throw new GradlePluginsRuntimeException("Page index out of bounds: " + index);
        }
        Page page = this.pages.get(index);
        this.switchToPage(page);
    }

    public void switchToPage(Page page) {
        SubActionBars actionBars;
        int index = this.pages.indexOf(page);
        if (index == -1 && page != this.defaultPage) {
            throw new GradlePluginsRuntimeException("Unknown page: " + page.getDisplayName());
        }
        if (this.currentPage != null) {
            this.removeSelectionListenerThatUpdatesSelectionProvider(this.currentPage);
            actionBars = (SubActionBars)this.currentPage.getSite().getActionBars();
            actionBars.deactivate();
        }
        this.currentPage = page;
        this.stackLayout.topControl = page.getPageControl();
        this.stackComposite.layout();
        this.addSelectionListenerThatUpdatesSelectionProvider(page);
        actionBars = (SubActionBars)page.getSite().getActionBars();
        actionBars.activate();
        this.getViewSite().getActionBars().updateActionBars();
    }

    private void addSelectionListenerThatUpdatesSelectionProvider(Page page) {
        ISelectionProvider selectionProvider = (ISelectionProvider)page.getAdapter(ISelectionProvider.class);
        if (selectionProvider != null) {
            selectionProvider.addSelectionChangedListener(this.selectionChangedListener);
            this.pageSelectionProvider.setSelection(selectionProvider.getSelection());
        }
    }

    private void removeSelectionListenerThatUpdatesSelectionProvider(Page page) {
        ISelectionProvider selectionProvider = (ISelectionProvider)page.getAdapter(ISelectionProvider.class);
        if (selectionProvider != null) {
            selectionProvider.removeSelectionChangedListener(this.selectionChangedListener);
        }
    }

    public Page getCurrentPage() {
        return this.currentPage != this.defaultPage ? this.currentPage : null;
    }

    public List<Page> getPages() {
        return ImmutableList.copyOf(this.pages);
    }

    public boolean hasPages() {
        return !this.pages.isEmpty();
    }

    protected void updateVisibilityOfGlobalActions() {
    }

    private void refreshGlobalActionHandlers() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.clearGlobalActionHandlers();
        Map newActionHandlers = ((SubActionBars)this.getCurrentPage().getSite().getActionBars()).getGlobalActionHandlers();
        if (newActionHandlers != null) {
            for (Map.Entry entry : newActionHandlers.entrySet()) {
                actionBars.setGlobalActionHandler((String)entry.getKey(), (IAction)entry.getValue());
            }
        }
    }

    public void setFocus() {
        Page currentPage = this.getCurrentPage();
        if (currentPage != null) {
            currentPage.setFocus();
        } else {
            this.defaultPage.setFocus();
        }
    }

    public void dispose() {
        Iterator<Page> iterator = this.pages.iterator();
        while (iterator.hasNext()) {
            Page page = iterator.next();
            page.getSite().dispose();
            page.dispose();
            iterator.remove();
        }
        super.dispose();
    }

    private static final class ActionBarsPropertyChangeListener
    implements IPropertyChangeListener {
        private final MultiPageView multiPageView;

        private ActionBarsPropertyChangeListener(MultiPageView multiPageView) {
            this.multiPageView = (MultiPageView)((Object)Preconditions.checkNotNull((Object)((Object)multiPageView)));
        }

        public void propertyChange(PropertyChangeEvent event) {
            Page currentPage;
            if ("org.eclipse.ui.internal.actionHandlers".equals(event.getProperty()) && (currentPage = this.multiPageView.getCurrentPage()) != null && currentPage.getSite() != null && currentPage.getSite().getActionBars() == event.getSource()) {
                this.multiPageView.refreshGlobalActionHandlers();
            }
        }
    }

    private static final class ForwardingSelectionChangedListener
    implements ISelectionChangedListener {
        private final ISelectionProvider selectionProvider;

        private ForwardingSelectionChangedListener(ISelectionProvider selectionProvider) {
            this.selectionProvider = (ISelectionProvider)Preconditions.checkNotNull((Object)selectionProvider);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.selectionProvider.setSelection(event.getSelection());
        }
    }

    private static final class PageSelectionProvider
    implements ISelectionProvider {
        private final List<ISelectionChangedListener> selectionChangedListeners = Lists.newCopyOnWriteArrayList();
        private ISelection selection;

        private PageSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.add(listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.selectionChangedListeners.remove(listener);
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
            this.selection = selection;
            final SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, selection);
            for (final ISelectionChangedListener listener : this.selectionChangedListeners) {
                SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                    public void run() {
                        listener.selectionChanged(selectionChangedEvent);
                    }
                });
            }
        }
    }

    private static final class DefaultPageSite
    implements PageSite {
        private final IViewSite viewSite;
        private final SubActionBars subActionBars;

        private DefaultPageSite(IViewSite viewSite) {
            this.viewSite = (IViewSite)Preconditions.checkNotNull((Object)viewSite);
            this.subActionBars = new SubActionBars(viewSite.getActionBars());
        }

        @Override
        public IViewSite getViewSite() {
            return this.viewSite;
        }

        @Override
        public IActionBars getActionBars() {
            return this.subActionBars;
        }

        @Override
        public void dispose() {
            this.subActionBars.dispose();
        }
    }
}

